/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * Event
 * 
 * <p>The event type
 */
@JsonDeserialize(using = Event._Deserializer.class)
@JsonSerialize(using = Event._Serializer.class)
public class Event {

    public static final Event SCREENING_RESULTS_CREATED = new Event("screening.results.created");
    public static final Event SCREENING_RESULTS_UPDATED = new Event("screening.results.updated");
    public static final Event SCREENING_RESULTS_COMPLETED = new Event("screening.results.completed");
    public static final Event SCREENING_RESULTS_FAILED = new Event("screening.results.failed");
    public static final Event SCREENING_RESULTS_CANCELLED = new Event("screening.results.cancelled");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, Event> values = createValuesMap();
    private static final Map<String, EventEnum> enums = createEnumsMap();

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    /**
     * Returns a Event with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as Event
     */ 
    public static Event of(String value) {
        synchronized (Event.class) {
            return values.computeIfAbsent(value, v -> new Event(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<EventEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Event other = (Event) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "Event [value=" + value + "]";
    }

    // return an array just like an enum
    public static Event[] values() {
        synchronized (Event.class) {
            return values.values().toArray(new Event[] {});
        }
    }

    private static final Map<String, Event> createValuesMap() {
        Map<String, Event> map = new LinkedHashMap<>();
        map.put("screening.results.created", SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", SCREENING_RESULTS_CANCELLED);
        return map;
    }

    private static final Map<String, EventEnum> createEnumsMap() {
        Map<String, EventEnum> map = new HashMap<>();
        map.put("screening.results.created", EventEnum.SCREENING_RESULTS_CREATED);
        map.put("screening.results.updated", EventEnum.SCREENING_RESULTS_UPDATED);
        map.put("screening.results.completed", EventEnum.SCREENING_RESULTS_COMPLETED);
        map.put("screening.results.failed", EventEnum.SCREENING_RESULTS_FAILED);
        map.put("screening.results.cancelled", EventEnum.SCREENING_RESULTS_CANCELLED);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<Event> {

        protected _Serializer() {
            super(Event.class);
        }

        @Override
        public void serialize(Event value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<Event> {

        protected _Deserializer() {
            super(Event.class);
        }

        @Override
        public Event deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return Event.of(v);
        }
    }
    
    public enum EventEnum {

        SCREENING_RESULTS_CREATED("screening.results.created"),
        SCREENING_RESULTS_UPDATED("screening.results.updated"),
        SCREENING_RESULTS_COMPLETED("screening.results.completed"),
        SCREENING_RESULTS_FAILED("screening.results.failed"),
        SCREENING_RESULTS_CANCELLED("screening.results.cancelled"),;

        private final String value;

        private EventEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

