/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class TicketingAttachmentResultData {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The reference ticket ID the attachment belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("ticket_id")
    private JsonNullable<String> ticketId;

    /**
     * The user who uploaded the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("user_id")
    private JsonNullable<String> userId;

    /**
     * The name of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_name")
    private JsonNullable<String> fileName;

    /**
     * The type of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends TicketingAttachmentResultFileFormat> fileFormat;

    /**
     * The resource URL of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_url")
    private JsonNullable<String> fileUrl;

    /**
     * The size of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("size")
    private JsonNullable<Double> size;

    /**
     * The timestamp when the record was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The timestamp when the record was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public TicketingAttachmentResultData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("ticket_id") JsonNullable<String> ticketId,
            @JsonProperty("user_id") JsonNullable<String> userId,
            @JsonProperty("file_name") JsonNullable<String> fileName,
            @JsonProperty("file_format") JsonNullable<? extends TicketingAttachmentResultFileFormat> fileFormat,
            @JsonProperty("file_url") JsonNullable<String> fileUrl,
            @JsonProperty("size") JsonNullable<Double> size,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(ticketId, "ticketId");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(fileName, "fileName");
        Utils.checkNotNull(fileFormat, "fileFormat");
        Utils.checkNotNull(fileUrl, "fileUrl");
        Utils.checkNotNull(size, "size");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.ticketId = ticketId;
        this.userId = userId;
        this.fileName = fileName;
        this.fileFormat = fileFormat;
        this.fileUrl = fileUrl;
        this.size = size;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public TicketingAttachmentResultData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The reference ticket ID the attachment belongs to
     */
    @JsonIgnore
    public JsonNullable<String> ticketId() {
        return ticketId;
    }

    /**
     * The user who uploaded the file
     */
    @JsonIgnore
    public JsonNullable<String> userId() {
        return userId;
    }

    /**
     * The name of the file
     */
    @JsonIgnore
    public JsonNullable<String> fileName() {
        return fileName;
    }

    /**
     * The type of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingAttachmentResultFileFormat> fileFormat() {
        return (JsonNullable<TicketingAttachmentResultFileFormat>) fileFormat;
    }

    /**
     * The resource URL of the file
     */
    @JsonIgnore
    public JsonNullable<String> fileUrl() {
        return fileUrl;
    }

    /**
     * The size of the file
     */
    @JsonIgnore
    public JsonNullable<Double> size() {
        return size;
    }

    /**
     * The timestamp when the record was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The timestamp when the record was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public TicketingAttachmentResultData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public TicketingAttachmentResultData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingAttachmentResultData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public TicketingAttachmentResultData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The reference ticket ID the attachment belongs to
     */
    public TicketingAttachmentResultData withTicketId(String ticketId) {
        Utils.checkNotNull(ticketId, "ticketId");
        this.ticketId = JsonNullable.of(ticketId);
        return this;
    }

    /**
     * The reference ticket ID the attachment belongs to
     */
    public TicketingAttachmentResultData withTicketId(JsonNullable<String> ticketId) {
        Utils.checkNotNull(ticketId, "ticketId");
        this.ticketId = ticketId;
        return this;
    }

    /**
     * The user who uploaded the file
     */
    public TicketingAttachmentResultData withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = JsonNullable.of(userId);
        return this;
    }

    /**
     * The user who uploaded the file
     */
    public TicketingAttachmentResultData withUserId(JsonNullable<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    /**
     * The name of the file
     */
    public TicketingAttachmentResultData withFileName(String fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = JsonNullable.of(fileName);
        return this;
    }

    /**
     * The name of the file
     */
    public TicketingAttachmentResultData withFileName(JsonNullable<String> fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = fileName;
        return this;
    }

    /**
     * The type of the file
     */
    public TicketingAttachmentResultData withFileFormat(TicketingAttachmentResultFileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The type of the file
     */
    public TicketingAttachmentResultData withFileFormat(JsonNullable<? extends TicketingAttachmentResultFileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    /**
     * The resource URL of the file
     */
    public TicketingAttachmentResultData withFileUrl(String fileUrl) {
        Utils.checkNotNull(fileUrl, "fileUrl");
        this.fileUrl = JsonNullable.of(fileUrl);
        return this;
    }

    /**
     * The resource URL of the file
     */
    public TicketingAttachmentResultData withFileUrl(JsonNullable<String> fileUrl) {
        Utils.checkNotNull(fileUrl, "fileUrl");
        this.fileUrl = fileUrl;
        return this;
    }

    /**
     * The size of the file
     */
    public TicketingAttachmentResultData withSize(double size) {
        Utils.checkNotNull(size, "size");
        this.size = JsonNullable.of(size);
        return this;
    }

    /**
     * The size of the file
     */
    public TicketingAttachmentResultData withSize(JsonNullable<Double> size) {
        Utils.checkNotNull(size, "size");
        this.size = size;
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingAttachmentResultData withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The timestamp when the record was created
     */
    public TicketingAttachmentResultData withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingAttachmentResultData withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The timestamp when the record was last updated
     */
    public TicketingAttachmentResultData withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingAttachmentResultData other = (TicketingAttachmentResultData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.ticketId, other.ticketId) &&
            Utils.enhancedDeepEquals(this.userId, other.userId) &&
            Utils.enhancedDeepEquals(this.fileName, other.fileName) &&
            Utils.enhancedDeepEquals(this.fileFormat, other.fileFormat) &&
            Utils.enhancedDeepEquals(this.fileUrl, other.fileUrl) &&
            Utils.enhancedDeepEquals(this.size, other.size) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, ticketId,
            userId, fileName, fileFormat,
            fileUrl, size, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingAttachmentResultData.class,
                "id", id,
                "remoteId", remoteId,
                "ticketId", ticketId,
                "userId", userId,
                "fileName", fileName,
                "fileFormat", fileFormat,
                "fileUrl", fileUrl,
                "size", size,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> ticketId = JsonNullable.undefined();

        private JsonNullable<String> userId = JsonNullable.undefined();

        private JsonNullable<String> fileName = JsonNullable.undefined();

        private JsonNullable<? extends TicketingAttachmentResultFileFormat> fileFormat = JsonNullable.undefined();

        private JsonNullable<String> fileUrl = JsonNullable.undefined();

        private JsonNullable<Double> size = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The reference ticket ID the attachment belongs to
         */
        public Builder ticketId(String ticketId) {
            Utils.checkNotNull(ticketId, "ticketId");
            this.ticketId = JsonNullable.of(ticketId);
            return this;
        }

        /**
         * The reference ticket ID the attachment belongs to
         */
        public Builder ticketId(JsonNullable<String> ticketId) {
            Utils.checkNotNull(ticketId, "ticketId");
            this.ticketId = ticketId;
            return this;
        }


        /**
         * The user who uploaded the file
         */
        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = JsonNullable.of(userId);
            return this;
        }

        /**
         * The user who uploaded the file
         */
        public Builder userId(JsonNullable<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }


        /**
         * The name of the file
         */
        public Builder fileName(String fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = JsonNullable.of(fileName);
            return this;
        }

        /**
         * The name of the file
         */
        public Builder fileName(JsonNullable<String> fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = fileName;
            return this;
        }


        /**
         * The type of the file
         */
        public Builder fileFormat(TicketingAttachmentResultFileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The type of the file
         */
        public Builder fileFormat(JsonNullable<? extends TicketingAttachmentResultFileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }


        /**
         * The resource URL of the file
         */
        public Builder fileUrl(String fileUrl) {
            Utils.checkNotNull(fileUrl, "fileUrl");
            this.fileUrl = JsonNullable.of(fileUrl);
            return this;
        }

        /**
         * The resource URL of the file
         */
        public Builder fileUrl(JsonNullable<String> fileUrl) {
            Utils.checkNotNull(fileUrl, "fileUrl");
            this.fileUrl = fileUrl;
            return this;
        }


        /**
         * The size of the file
         */
        public Builder size(double size) {
            Utils.checkNotNull(size, "size");
            this.size = JsonNullable.of(size);
            return this;
        }

        /**
         * The size of the file
         */
        public Builder size(JsonNullable<Double> size) {
            Utils.checkNotNull(size, "size");
            this.size = size;
            return this;
        }


        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The timestamp when the record was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The timestamp when the record was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public TicketingAttachmentResultData build() {

            return new TicketingAttachmentResultData(
                id, remoteId, ticketId,
                userId, fileName, fileFormat,
                fileUrl, size, createdAt,
                updatedAt);
        }

    }
}
