/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TaskResultStatus
 * 
 * <p>The status of the task
 */
public class TaskResultStatus {
    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TaskResultDataValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TaskResultDataSourceValue> sourceValue;

    @JsonCreator
    public TaskResultStatus(
            @JsonProperty("value") JsonNullable<? extends TaskResultDataValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TaskResultDataSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TaskResultStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskResultDataValue> value() {
        return (JsonNullable<TaskResultDataValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskResultDataSourceValue> sourceValue() {
        return (JsonNullable<TaskResultDataSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    public TaskResultStatus withValue(TaskResultDataValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    public TaskResultStatus withValue(JsonNullable<? extends TaskResultDataValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TaskResultStatus withSourceValue(TaskResultDataSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public TaskResultStatus withSourceValue(JsonNullable<? extends TaskResultDataSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskResultStatus other = (TaskResultStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TaskResultStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends TaskResultDataValue> value = JsonNullable.undefined();

        private JsonNullable<? extends TaskResultDataSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
         */
        public Builder value(TaskResultDataValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
         */
        public Builder value(JsonNullable<? extends TaskResultDataValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(TaskResultDataSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TaskResultDataSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TaskResultStatus build() {

            return new TaskResultStatus(
                value, sourceValue);
        }

    }
}
