/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AtsListApplicationsQueryParamFilter
 * 
 * <p>ATS Application Filter
 */
public class AtsListApplicationsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Use a string with a date to only select results created after that given date
     */
    @SpeakeasyMetadata("queryParam:name=created_after")
    private JsonNullable<OffsetDateTime> createdAfter;

    /**
     * Filter to select applications by job_id
     */
    @SpeakeasyMetadata("queryParam:name=job_id")
    private JsonNullable<String> jobId;

    /**
     * Filter to select applications by stage and sub-stage
     */
    @SpeakeasyMetadata("queryParam:name=stage")
    private JsonNullable<String> stage;

    @JsonCreator
    public AtsListApplicationsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<OffsetDateTime> createdAfter,
            JsonNullable<String> jobId,
            JsonNullable<String> stage) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(createdAfter, "createdAfter");
        Utils.checkNotNull(jobId, "jobId");
        Utils.checkNotNull(stage, "stage");
        this.updatedAfter = updatedAfter;
        this.createdAfter = createdAfter;
        this.jobId = jobId;
        this.stage = stage;
    }
    
    public AtsListApplicationsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAfter() {
        return createdAfter;
    }

    /**
     * Filter to select applications by job_id
     */
    @JsonIgnore
    public JsonNullable<String> jobId() {
        return jobId;
    }

    /**
     * Filter to select applications by stage and sub-stage
     */
    @JsonIgnore
    public JsonNullable<String> stage() {
        return stage;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListApplicationsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListApplicationsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListApplicationsQueryParamFilter withCreatedAfter(OffsetDateTime createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = JsonNullable.of(createdAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListApplicationsQueryParamFilter withCreatedAfter(JsonNullable<OffsetDateTime> createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = createdAfter;
        return this;
    }

    /**
     * Filter to select applications by job_id
     */
    public AtsListApplicationsQueryParamFilter withJobId(String jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = JsonNullable.of(jobId);
        return this;
    }

    /**
     * Filter to select applications by job_id
     */
    public AtsListApplicationsQueryParamFilter withJobId(JsonNullable<String> jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = jobId;
        return this;
    }

    /**
     * Filter to select applications by stage and sub-stage
     */
    public AtsListApplicationsQueryParamFilter withStage(String stage) {
        Utils.checkNotNull(stage, "stage");
        this.stage = JsonNullable.of(stage);
        return this;
    }

    /**
     * Filter to select applications by stage and sub-stage
     */
    public AtsListApplicationsQueryParamFilter withStage(JsonNullable<String> stage) {
        Utils.checkNotNull(stage, "stage");
        this.stage = stage;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationsQueryParamFilter other = (AtsListApplicationsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.createdAfter, other.createdAfter) &&
            Utils.enhancedDeepEquals(this.jobId, other.jobId) &&
            Utils.enhancedDeepEquals(this.stage, other.stage);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, createdAfter, jobId,
            stage);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsListApplicationsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "createdAfter", createdAfter,
                "jobId", jobId,
                "stage", stage);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAfter = JsonNullable.undefined();

        private JsonNullable<String> jobId = JsonNullable.undefined();

        private JsonNullable<String> stage = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(OffsetDateTime createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = JsonNullable.of(createdAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(JsonNullable<OffsetDateTime> createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = createdAfter;
            return this;
        }


        /**
         * Filter to select applications by job_id
         */
        public Builder jobId(String jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = JsonNullable.of(jobId);
            return this;
        }

        /**
         * Filter to select applications by job_id
         */
        public Builder jobId(JsonNullable<String> jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = jobId;
            return this;
        }


        /**
         * Filter to select applications by stage and sub-stage
         */
        public Builder stage(String stage) {
            Utils.checkNotNull(stage, "stage");
            this.stage = JsonNullable.of(stage);
            return this;
        }

        /**
         * Filter to select applications by stage and sub-stage
         */
        public Builder stage(JsonNullable<String> stage) {
            Utils.checkNotNull(stage, "stage");
            this.stage = stage;
            return this;
        }

        public AtsListApplicationsQueryParamFilter build() {

            return new AtsListApplicationsQueryParamFilter(
                updatedAfter, createdAfter, jobId,
                stage);
        }

    }
}
