/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class AccountingAccountResultValue {
    public static final AccountingAccountResultValue ASSET = new AccountingAccountResultValue("asset");
    public static final AccountingAccountResultValue LIABILITY = new AccountingAccountResultValue("liability");
    public static final AccountingAccountResultValue EQUITY = new AccountingAccountResultValue("equity");
    public static final AccountingAccountResultValue REVENUE = new AccountingAccountResultValue("revenue");
    public static final AccountingAccountResultValue EXPENSE = new AccountingAccountResultValue("expense");
    public static final AccountingAccountResultValue UNMAPPED_VALUE = new AccountingAccountResultValue("unmapped_value");
    private static final Map<String, AccountingAccountResultValue> values = AccountingAccountResultValue.createValuesMap();
    private static final Map<String, AccountingAccountResultValueEnum> enums = AccountingAccountResultValue.createEnumsMap();
    private final String value;

    private AccountingAccountResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingAccountResultValue of(String value) {
        Class<AccountingAccountResultValue> clazz = AccountingAccountResultValue.class;
        synchronized (AccountingAccountResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingAccountResultValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<AccountingAccountResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingAccountResultValue other = (AccountingAccountResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingAccountResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingAccountResultValue[] values() {
        Class<AccountingAccountResultValue> clazz = AccountingAccountResultValue.class;
        synchronized (AccountingAccountResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingAccountResultValue[0]);
        }
    }

    private static final Map<String, AccountingAccountResultValue> createValuesMap() {
        LinkedHashMap<String, AccountingAccountResultValue> map = new LinkedHashMap<String, AccountingAccountResultValue>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountResultValueEnum> createEnumsMap() {
        HashMap<String, AccountingAccountResultValueEnum> map = new HashMap<String, AccountingAccountResultValueEnum>();
        map.put("asset", AccountingAccountResultValueEnum.ASSET);
        map.put("liability", AccountingAccountResultValueEnum.LIABILITY);
        map.put("equity", AccountingAccountResultValueEnum.EQUITY);
        map.put("revenue", AccountingAccountResultValueEnum.REVENUE);
        map.put("expense", AccountingAccountResultValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingAccountResultValueEnum {
        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingAccountResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<AccountingAccountResultValue> {
        protected _Deserializer() {
            super(AccountingAccountResultValue.class);
        }

        public AccountingAccountResultValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return AccountingAccountResultValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<AccountingAccountResultValue> {
        protected _Serializer() {
            super(AccountingAccountResultValue.class);
        }

        public void serialize(AccountingAccountResultValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

