/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.EmailTemplateResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingGetEmailTemplateResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends EmailTemplateResult> emailTemplateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetEmailTemplateResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends EmailTemplateResult> emailTemplateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(emailTemplateResult, "emailTemplateResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.emailTemplateResult = emailTemplateResult;
        this.headers = headers;
    }

    public MarketingGetEmailTemplateResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<EmailTemplateResult> emailTemplateResult() {
        return this.emailTemplateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingGetEmailTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingGetEmailTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingGetEmailTemplateResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingGetEmailTemplateResponse withEmailTemplateResult(EmailTemplateResult emailTemplateResult) {
        Utils.checkNotNull(emailTemplateResult, "emailTemplateResult");
        this.emailTemplateResult = Optional.ofNullable(emailTemplateResult);
        return this;
    }

    public MarketingGetEmailTemplateResponse withEmailTemplateResult(Optional<? extends EmailTemplateResult> emailTemplateResult) {
        Utils.checkNotNull(emailTemplateResult, "emailTemplateResult");
        this.emailTemplateResult = emailTemplateResult;
        return this;
    }

    public MarketingGetEmailTemplateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingGetEmailTemplateResponse other = (MarketingGetEmailTemplateResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.emailTemplateResult, other.emailTemplateResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.emailTemplateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingGetEmailTemplateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "emailTemplateResult", this.emailTemplateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends EmailTemplateResult> emailTemplateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder emailTemplateResult(EmailTemplateResult emailTemplateResult) {
            Utils.checkNotNull(emailTemplateResult, "emailTemplateResult");
            this.emailTemplateResult = Optional.ofNullable(emailTemplateResult);
            return this;
        }

        public Builder emailTemplateResult(Optional<? extends EmailTemplateResult> emailTemplateResult) {
            Utils.checkNotNull(emailTemplateResult, "emailTemplateResult");
            this.emailTemplateResult = emailTemplateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingGetEmailTemplateResponse build() {
            return new MarketingGetEmailTemplateResponse(this.contentType, this.statusCode, this.rawResponse, this.emailTemplateResult, this.headers);
        }
    }
}

