/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.TicketingTicketCreateRequestDto;
import com.stackone.stackone_client_java.models.components.TicketingTicketUpdateRequestDto;
import com.stackone.stackone_client_java.models.operations.TicketingCreateTicketRequest;
import com.stackone.stackone_client_java.models.operations.TicketingCreateTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingCreateTicketResponse;
import com.stackone.stackone_client_java.models.operations.TicketingDownloadTicketingAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingDownloadTicketingAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingDownloadTicketingAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetCommentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetCommentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetCommentResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectComponentRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectComponentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectComponentResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetProjectResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketTypeRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketTypeRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetTicketTypeResponse;
import com.stackone.stackone_client_java.models.operations.TicketingGetUserRequest;
import com.stackone.stackone_client_java.models.operations.TicketingGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingGetUserResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListAttachmentsResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListCommentsResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectComponentsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectComponentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectComponentsResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectTicketTypesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectTicketTypesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectTicketTypesResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketStatusesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketStatusesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketStatusesResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketTypesRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketTypesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketTypesResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsResponse;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingListUsersResponse;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketRequest;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketRequestBuilder;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketResponse;
import com.stackone.stackone_client_java.operations.TicketingCreateTicket;
import com.stackone.stackone_client_java.operations.TicketingDownloadTicketingAttachment;
import com.stackone.stackone_client_java.operations.TicketingGetAttachment;
import com.stackone.stackone_client_java.operations.TicketingGetComment;
import com.stackone.stackone_client_java.operations.TicketingGetProject;
import com.stackone.stackone_client_java.operations.TicketingGetProjectComponent;
import com.stackone.stackone_client_java.operations.TicketingGetTicket;
import com.stackone.stackone_client_java.operations.TicketingGetTicketType;
import com.stackone.stackone_client_java.operations.TicketingGetUser;
import com.stackone.stackone_client_java.operations.TicketingListAttachments;
import com.stackone.stackone_client_java.operations.TicketingListComments;
import com.stackone.stackone_client_java.operations.TicketingListProjectComponents;
import com.stackone.stackone_client_java.operations.TicketingListProjectTicketTypes;
import com.stackone.stackone_client_java.operations.TicketingListProjects;
import com.stackone.stackone_client_java.operations.TicketingListTicketStatuses;
import com.stackone.stackone_client_java.operations.TicketingListTicketTypes;
import com.stackone.stackone_client_java.operations.TicketingListTickets;
import com.stackone.stackone_client_java.operations.TicketingListUsers;
import com.stackone.stackone_client_java.operations.TicketingUpdateTicket;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;


public class Ticketing {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncTicketing asyncSDK;

    Ticketing(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncTicketing(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncTicketing async() {
        return asyncSDK;
    }

    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @return The call builder
     */
    public TicketingListTicketsRequestBuilder listTickets() {
        return new TicketingListTicketsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketsResponse listTickets(TicketingListTicketsRequest request) throws Exception {
        return listTickets(request, Optional.empty());
    }

    /**
     * List Tickets
     * 
     * <p>Retrieve a paginated list of tickets.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketsResponse listTickets(TicketingListTicketsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListTicketsRequest, TicketingListTicketsResponse> operation
              = new TicketingListTickets.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @return The call builder
     */
    public TicketingCreateTicketRequestBuilder createTicket() {
        return new TicketingCreateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @param xAccountId The account identifier
     * @param ticketingTicketCreateRequestDto 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingCreateTicketResponse createTicket(String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) throws Exception {
        return createTicket(xAccountId, ticketingTicketCreateRequestDto, Optional.empty());
    }

    /**
     * Create Ticket
     * 
     * <p>Create a new ticket record.
     * 
     * @param xAccountId The account identifier
     * @param ticketingTicketCreateRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingCreateTicketResponse createTicket(
            String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto,
            Optional<Options> options) throws Exception {
        TicketingCreateTicketRequest request =
            TicketingCreateTicketRequest
                .builder()
                .xAccountId(xAccountId)
                .ticketingTicketCreateRequestDto(ticketingTicketCreateRequestDto)
                .build();
        RequestOperation<TicketingCreateTicketRequest, TicketingCreateTicketResponse> operation
              = new TicketingCreateTicket.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @return The call builder
     */
    public TicketingGetTicketRequestBuilder getTicket() {
        return new TicketingGetTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetTicketResponse getTicket(TicketingGetTicketRequest request) throws Exception {
        return getTicket(request, Optional.empty());
    }

    /**
     * Get Ticket
     * 
     * <p>Retrieve a single ticket by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetTicketResponse getTicket(TicketingGetTicketRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetTicketRequest, TicketingGetTicketResponse> operation
              = new TicketingGetTicket.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @return The call builder
     */
    public TicketingUpdateTicketRequestBuilder updateTicket() {
        return new TicketingUpdateTicketRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param ticketingTicketUpdateRequestDto 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingUpdateTicketResponse updateTicket(
            String xAccountId, String id,
            TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) throws Exception {
        return updateTicket(xAccountId, id, ticketingTicketUpdateRequestDto,
            Optional.empty());
    }

    /**
     * Update Ticket
     * 
     * <p>Update an existing ticket record by its identifier.
     * 
     * @param xAccountId The account identifier
     * @param id 
     * @param ticketingTicketUpdateRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingUpdateTicketResponse updateTicket(
            String xAccountId, String id,
            TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto, Optional<Options> options) throws Exception {
        TicketingUpdateTicketRequest request =
            TicketingUpdateTicketRequest
                .builder()
                .xAccountId(xAccountId)
                .id(id)
                .ticketingTicketUpdateRequestDto(ticketingTicketUpdateRequestDto)
                .build();
        RequestOperation<TicketingUpdateTicketRequest, TicketingUpdateTicketResponse> operation
              = new TicketingUpdateTicket.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @return The call builder
     */
    public TicketingListUsersRequestBuilder listUsers() {
        return new TicketingListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListUsersResponse listUsers(TicketingListUsersRequest request) throws Exception {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * <p>Retrieve a paginated list of users.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListUsersResponse listUsers(TicketingListUsersRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListUsersRequest, TicketingListUsersResponse> operation
              = new TicketingListUsers.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @return The call builder
     */
    public TicketingGetUserRequestBuilder getUser() {
        return new TicketingGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetUserResponse getUser(TicketingGetUserRequest request) throws Exception {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * <p>Retrieve a single user by their identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetUserResponse getUser(TicketingGetUserRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetUserRequest, TicketingGetUserResponse> operation
              = new TicketingGetUser.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @return The call builder
     */
    public TicketingListCommentsRequestBuilder listComments() {
        return new TicketingListCommentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListCommentsResponse listComments(TicketingListCommentsRequest request) throws Exception {
        return listComments(request, Optional.empty());
    }

    /**
     * List Comments
     * 
     * <p>Retrieve a paginated list of comments for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListCommentsResponse listComments(TicketingListCommentsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListCommentsRequest, TicketingListCommentsResponse> operation
              = new TicketingListComments.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @return The call builder
     */
    public TicketingGetCommentRequestBuilder getComment() {
        return new TicketingGetCommentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetCommentResponse getComment(TicketingGetCommentRequest request) throws Exception {
        return getComment(request, Optional.empty());
    }

    /**
     * Get Comment
     * 
     * <p>Retrieve a single comment by its identifier for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetCommentResponse getComment(TicketingGetCommentRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetCommentRequest, TicketingGetCommentResponse> operation
              = new TicketingGetComment.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @return The call builder
     */
    public TicketingDownloadTicketingAttachmentRequestBuilder downloadTicketingAttachment() {
        return new TicketingDownloadTicketingAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingDownloadTicketingAttachmentResponse downloadTicketingAttachment(TicketingDownloadTicketingAttachmentRequest request) throws Exception {
        return downloadTicketingAttachment(request, Optional.empty());
    }

    /**
     * Download Attachment
     * 
     * <p>Download the attachment file from a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingDownloadTicketingAttachmentResponse downloadTicketingAttachment(TicketingDownloadTicketingAttachmentRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingDownloadTicketingAttachmentRequest, TicketingDownloadTicketingAttachmentResponse> operation
              = new TicketingDownloadTicketingAttachment.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @return The call builder
     */
    public TicketingListAttachmentsRequestBuilder listAttachments() {
        return new TicketingListAttachmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListAttachmentsResponse listAttachments(TicketingListAttachmentsRequest request) throws Exception {
        return listAttachments(request, Optional.empty());
    }

    /**
     * List Attachments
     * 
     * <p>Retrieve a paginated list of attachment details for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListAttachmentsResponse listAttachments(TicketingListAttachmentsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListAttachmentsRequest, TicketingListAttachmentsResponse> operation
              = new TicketingListAttachments.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @return The call builder
     */
    public TicketingGetAttachmentRequestBuilder getAttachment() {
        return new TicketingGetAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetAttachmentResponse getAttachment(TicketingGetAttachmentRequest request) throws Exception {
        return getAttachment(request, Optional.empty());
    }

    /**
     * Get Attachment
     * 
     * <p>Retrieve the details of a single attachment for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetAttachmentResponse getAttachment(TicketingGetAttachmentRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetAttachmentRequest, TicketingGetAttachmentResponse> operation
              = new TicketingGetAttachment.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @return The call builder
     */
    public TicketingListTicketTypesRequestBuilder listTicketTypes() {
        return new TicketingListTicketTypesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketTypesResponse listTicketTypes(TicketingListTicketTypesRequest request) throws Exception {
        return listTicketTypes(request, Optional.empty());
    }

    /**
     * List Ticket Types
     * 
     * <p>Retrieve a paginated list of all ticket types.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketTypesResponse listTicketTypes(TicketingListTicketTypesRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListTicketTypesRequest, TicketingListTicketTypesResponse> operation
              = new TicketingListTicketTypes.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @return The call builder
     */
    public TicketingGetTicketTypeRequestBuilder getTicketType() {
        return new TicketingGetTicketTypeRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetTicketTypeResponse getTicketType(TicketingGetTicketTypeRequest request) throws Exception {
        return getTicketType(request, Optional.empty());
    }

    /**
     * Get Ticket Type
     * 
     * <p>Retrieve a single ticket type by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetTicketTypeResponse getTicketType(TicketingGetTicketTypeRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetTicketTypeRequest, TicketingGetTicketTypeResponse> operation
              = new TicketingGetTicketType.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @return The call builder
     */
    public TicketingListProjectsRequestBuilder listProjects() {
        return new TicketingListProjectsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectsResponse listProjects(TicketingListProjectsRequest request) throws Exception {
        return listProjects(request, Optional.empty());
    }

    /**
     * List Projects
     * 
     * <p>Retrieve a paginated list of projects.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectsResponse listProjects(TicketingListProjectsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListProjectsRequest, TicketingListProjectsResponse> operation
              = new TicketingListProjects.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @return The call builder
     */
    public TicketingGetProjectRequestBuilder getProject() {
        return new TicketingGetProjectRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetProjectResponse getProject(TicketingGetProjectRequest request) throws Exception {
        return getProject(request, Optional.empty());
    }

    /**
     * Get Project
     * 
     * <p>Retrieve a single project by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetProjectResponse getProject(TicketingGetProjectRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetProjectRequest, TicketingGetProjectResponse> operation
              = new TicketingGetProject.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @return The call builder
     */
    public TicketingListProjectComponentsRequestBuilder listProjectComponents() {
        return new TicketingListProjectComponentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectComponentsResponse listProjectComponents(TicketingListProjectComponentsRequest request) throws Exception {
        return listProjectComponents(request, Optional.empty());
    }

    /**
     * List Project Components
     * 
     * <p>Retrieve a paginated list of project components.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectComponentsResponse listProjectComponents(TicketingListProjectComponentsRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListProjectComponentsRequest, TicketingListProjectComponentsResponse> operation
              = new TicketingListProjectComponents.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @return The call builder
     */
    public TicketingGetProjectComponentRequestBuilder getProjectComponent() {
        return new TicketingGetProjectComponentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetProjectComponentResponse getProjectComponent(TicketingGetProjectComponentRequest request) throws Exception {
        return getProjectComponent(request, Optional.empty());
    }

    /**
     * Get Project Component
     * 
     * <p>Retrieve a single project component by its identifier.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingGetProjectComponentResponse getProjectComponent(TicketingGetProjectComponentRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingGetProjectComponentRequest, TicketingGetProjectComponentResponse> operation
              = new TicketingGetProjectComponent.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @return The call builder
     */
    public TicketingListProjectTicketTypesRequestBuilder listProjectTicketTypes() {
        return new TicketingListProjectTicketTypesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectTicketTypesResponse listProjectTicketTypes(TicketingListProjectTicketTypesRequest request) throws Exception {
        return listProjectTicketTypes(request, Optional.empty());
    }

    /**
     * List Project Ticket Types
     * 
     * <p>Retrieve a paginated list of ticket types for a project.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListProjectTicketTypesResponse listProjectTicketTypes(TicketingListProjectTicketTypesRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListProjectTicketTypesRequest, TicketingListProjectTicketTypesResponse> operation
              = new TicketingListProjectTicketTypes.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @return The call builder
     */
    public TicketingListTicketStatusesRequestBuilder listTicketStatuses() {
        return new TicketingListTicketStatusesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketStatusesResponse listTicketStatuses(TicketingListTicketStatusesRequest request) throws Exception {
        return listTicketStatuses(request, Optional.empty());
    }

    /**
     * List Ticket Statuses
     * 
     * <p>Retrieve a paginated list of statuses for a ticket.
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public TicketingListTicketStatusesResponse listTicketStatuses(TicketingListTicketStatusesRequest request, Optional<Options> options) throws Exception {
        RequestOperation<TicketingListTicketStatusesRequest, TicketingListTicketStatusesResponse> operation
              = new TicketingListTicketStatuses.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
