/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsCreateNotesRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsCreateApplicationNoteRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsCreateApplicationNoteResponse;
import com.stackone.stackone_client_java.operations.AtsCreateApplicationNote;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AtsCreateApplicationNoteRequestBuilder {
    private String xAccountId;
    private String id;
    private AtsCreateNotesRequestDto atsCreateNotesRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public AtsCreateApplicationNoteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsCreateApplicationNoteRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateApplicationNoteRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsCreateApplicationNoteRequestBuilder atsCreateNotesRequestDto(AtsCreateNotesRequestDto atsCreateNotesRequestDto) {
        Utils.checkNotNull(atsCreateNotesRequestDto, "atsCreateNotesRequestDto");
        this.atsCreateNotesRequestDto = atsCreateNotesRequestDto;
        return this;
    }

    public AtsCreateApplicationNoteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsCreateApplicationNoteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsCreateApplicationNoteRequest buildRequest() {
        AtsCreateApplicationNoteRequest request = new AtsCreateApplicationNoteRequest(this.xAccountId, this.id, this.atsCreateNotesRequestDto);
        return request;
    }

    public CompletableFuture<AtsCreateApplicationNoteResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsCreateApplicationNote.Async operation = new AtsCreateApplicationNote.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        AtsCreateApplicationNoteRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

