/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpDeleteSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpGetSecurity;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.operations.StackoneMcpDelete;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;

/**
 * Model Context Protocol endpoint.
 */
public class Mcp {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncMcp asyncSDK;

    Mcp(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncMcp(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncMcp async() {
        return asyncSDK;
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @return The call builder
     */
    public StackoneMcpGetRequestBuilder mcpGet() {
        return new StackoneMcpGetRequestBuilder(sdkConfiguration);
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpGetResponse mcpGet(
            StackoneMcpGetSecurity security, String xAccountId,
            String mcpSessionId) {
        return mcpGet(security, xAccountId, mcpSessionId,
            Optional.empty());
    }

    /**
     * Open MCP SSE stream
     * 
     * <p>Open a dedicated Server-Sent Events stream for MCP notifications
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpGetResponse mcpGet(
            StackoneMcpGetSecurity security, String xAccountId,
            String mcpSessionId, Optional<Options> options) {
        StackoneMcpGetRequest request =
            StackoneMcpGetRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .build();
        RequestOperation<StackoneMcpGetRequest, StackoneMcpGetResponse> operation
              = new StackoneMcpGet.Sync(
                                    sdkConfiguration, security, options,
                                    _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @return The call builder
     */
    public StackoneMcpPostRequestBuilder mcpPost() {
        return new StackoneMcpPostRequestBuilder(sdkConfiguration);
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param jsonRpcMessageDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpPostResponse mcpPost(
            StackoneMcpPostSecurity security, String xAccountId,
            JsonRpcMessageDto jsonRpcMessageDto) {
        return mcpPost(security, xAccountId, Optional.empty(),
            jsonRpcMessageDto, Optional.empty());
    }

    /**
     * Send MCP JSON-RPC message
     * 
     * <p>Send JSON-RPC request to the MCP server over HTTP streaming transport
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id; omit for initialize, include for subsequent calls
     * @param jsonRpcMessageDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpPostResponse mcpPost(
            StackoneMcpPostSecurity security, String xAccountId,
            Optional<String> mcpSessionId, JsonRpcMessageDto jsonRpcMessageDto,
            Optional<Options> options) {
        StackoneMcpPostRequest request =
            StackoneMcpPostRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .jsonRpcMessageDto(jsonRpcMessageDto)
                .build();
        RequestOperation<StackoneMcpPostRequest, StackoneMcpPostResponse> operation
              = new StackoneMcpPost.Sync(
                                    sdkConfiguration, security, options,
                                    _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @return The call builder
     */
    public StackoneMcpDeleteRequestBuilder mcpDelete() {
        return new StackoneMcpDeleteRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpDeleteResponse mcpDelete(
            StackoneMcpDeleteSecurity security, String xAccountId,
            String mcpSessionId) {
        return mcpDelete(security, xAccountId, mcpSessionId,
            Optional.empty());
    }

    /**
     * Delete MCP session
     * 
     * <p>Close an existing MCP session for the provided session id
     * 
     * @param security The security details to use for authentication.
     * @param xAccountId Account secure id for the target provider account
     * @param mcpSessionId Session id
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneMcpDeleteResponse mcpDelete(
            StackoneMcpDeleteSecurity security, String xAccountId,
            String mcpSessionId, Optional<Options> options) {
        StackoneMcpDeleteRequest request =
            StackoneMcpDeleteRequest
                .builder()
                .xAccountId(xAccountId)
                .mcpSessionId(mcpSessionId)
                .build();
        RequestOperation<StackoneMcpDeleteRequest, StackoneMcpDeleteResponse> operation
              = new StackoneMcpDelete.Sync(
                                    sdkConfiguration, security, options,
                                    _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
