/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class DownloadApiModel {
    /**
     * Headers related to the download
     */
    @JsonProperty("headers")
    private DownloadHeadersApiModel headers;

    /**
     * The file data in binary format
     */
    @JsonProperty("data")
    private byte[] data;

    @JsonCreator
    public DownloadApiModel(
            @JsonProperty("headers") DownloadHeadersApiModel headers,
            @JsonProperty("data") byte[] data) {
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(data, "data");
        this.headers = headers;
        this.data = data;
    }

    /**
     * Headers related to the download
     */
    @JsonIgnore
    public DownloadHeadersApiModel headers() {
        return headers;
    }

    /**
     * The file data in binary format
     */
    @JsonIgnore
    public byte[] data() {
        return data;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Headers related to the download
     */
    public DownloadApiModel withHeaders(DownloadHeadersApiModel headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    /**
     * The file data in binary format
     */
    public DownloadApiModel withData(byte[] data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DownloadApiModel other = (DownloadApiModel) o;
        return 
            Utils.enhancedDeepEquals(this.headers, other.headers) &&
            Utils.enhancedDeepEquals(this.data, other.data);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            headers, data);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DownloadApiModel.class,
                "headers", headers,
                "data", data);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private DownloadHeadersApiModel headers;

        private byte[] data;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Headers related to the download
         */
        public Builder headers(DownloadHeadersApiModel headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }


        /**
         * The file data in binary format
         */
        public Builder data(byte[] data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public DownloadApiModel build() {

            return new DownloadApiModel(
                headers, data);
        }

    }
}
