/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class MessagingSendMessageRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

    @JsonCreator
    public MessagingSendMessageRequest(
            String xAccountId,
            MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.xAccountId = xAccountId;
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public MessagingMessageSendRequestDto messagingMessageSendRequestDto() {
        return messagingMessageSendRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public MessagingSendMessageRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingSendMessageRequest withMessagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingSendMessageRequest other = (MessagingSendMessageRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.messagingMessageSendRequestDto, other.messagingMessageSendRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, messagingMessageSendRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingSendMessageRequest.class,
                "xAccountId", xAccountId,
                "messagingMessageSendRequestDto", messagingMessageSendRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private MessagingMessageSendRequestDto messagingMessageSendRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder messagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
            Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
            this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
            return this;
        }

        public MessagingSendMessageRequest build() {

            return new MessagingSendMessageRequest(
                xAccountId, messagingMessageSendRequestDto);
        }

    }
}
