/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.operations.StackoneMcpGet;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;

public class StackoneMcpGetRequestBuilder {

    private StackoneMcpGetSecurity security;
    private String xAccountId;
    private String mcpSessionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public StackoneMcpGetRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpGetRequestBuilder security(StackoneMcpGetSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpGetRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpGetRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }
                
    public StackoneMcpGetRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpGetRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private StackoneMcpGetRequest buildRequest() {

        StackoneMcpGetRequest request = new StackoneMcpGetRequest(xAccountId,
            mcpSessionId);

        return request;
    }

    public StackoneMcpGetResponse call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<StackoneMcpGetRequest, StackoneMcpGetResponse> operation
              = new StackoneMcpGet.Sync(
                                    sdkConfiguration, security, options,
                                    _headers);
        StackoneMcpGetRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
