/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * MessagingMessageContent
 * 
 * <p>Content of the message
 */
public class MessagingMessageContent {
    /**
     * HTML content of the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("html")
    private JsonNullable<String> html;

    /**
     * Plain text content of the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("plain")
    private JsonNullable<String> plain;

    @JsonCreator
    public MessagingMessageContent(
            @JsonProperty("html") JsonNullable<String> html,
            @JsonProperty("plain") JsonNullable<String> plain) {
        Utils.checkNotNull(html, "html");
        Utils.checkNotNull(plain, "plain");
        this.html = html;
        this.plain = plain;
    }
    
    public MessagingMessageContent() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * HTML content of the message
     */
    @JsonIgnore
    public JsonNullable<String> html() {
        return html;
    }

    /**
     * Plain text content of the message
     */
    @JsonIgnore
    public JsonNullable<String> plain() {
        return plain;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTML content of the message
     */
    public MessagingMessageContent withHtml(String html) {
        Utils.checkNotNull(html, "html");
        this.html = JsonNullable.of(html);
        return this;
    }

    /**
     * HTML content of the message
     */
    public MessagingMessageContent withHtml(JsonNullable<String> html) {
        Utils.checkNotNull(html, "html");
        this.html = html;
        return this;
    }

    /**
     * Plain text content of the message
     */
    public MessagingMessageContent withPlain(String plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = JsonNullable.of(plain);
        return this;
    }

    /**
     * Plain text content of the message
     */
    public MessagingMessageContent withPlain(JsonNullable<String> plain) {
        Utils.checkNotNull(plain, "plain");
        this.plain = plain;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingMessageContent other = (MessagingMessageContent) o;
        return 
            Utils.enhancedDeepEquals(this.html, other.html) &&
            Utils.enhancedDeepEquals(this.plain, other.plain);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            html, plain);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingMessageContent.class,
                "html", html,
                "plain", plain);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> html = JsonNullable.undefined();

        private JsonNullable<String> plain = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTML content of the message
         */
        public Builder html(String html) {
            Utils.checkNotNull(html, "html");
            this.html = JsonNullable.of(html);
            return this;
        }

        /**
         * HTML content of the message
         */
        public Builder html(JsonNullable<String> html) {
            Utils.checkNotNull(html, "html");
            this.html = html;
            return this;
        }


        /**
         * Plain text content of the message
         */
        public Builder plain(String plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = JsonNullable.of(plain);
            return this;
        }

        /**
         * Plain text content of the message
         */
        public Builder plain(JsonNullable<String> plain) {
            Utils.checkNotNull(plain, "plain");
            this.plain = plain;
            return this;
        }

        public MessagingMessageContent build() {

            return new MessagingMessageContent(
                html, plain);
        }

    }
}
