/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class UpdateTaskRequestDto {
    /**
     * Comment or note about the task update
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("comment")
    private JsonNullable<String> comment;

    /**
     * The status to apply to this Task
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends UpdateTaskRequestDtoStatus> status;

    @JsonCreator
    public UpdateTaskRequestDto(
            @JsonProperty("comment") JsonNullable<String> comment,
            @JsonProperty("status") JsonNullable<? extends UpdateTaskRequestDtoStatus> status) {
        Utils.checkNotNull(comment, "comment");
        Utils.checkNotNull(status, "status");
        this.comment = comment;
        this.status = status;
    }
    
    public UpdateTaskRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Comment or note about the task update
     */
    @JsonIgnore
    public JsonNullable<String> comment() {
        return comment;
    }

    /**
     * The status to apply to this Task
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<UpdateTaskRequestDtoStatus> status() {
        return (JsonNullable<UpdateTaskRequestDtoStatus>) status;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Comment or note about the task update
     */
    public UpdateTaskRequestDto withComment(String comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = JsonNullable.of(comment);
        return this;
    }

    /**
     * Comment or note about the task update
     */
    public UpdateTaskRequestDto withComment(JsonNullable<String> comment) {
        Utils.checkNotNull(comment, "comment");
        this.comment = comment;
        return this;
    }

    /**
     * The status to apply to this Task
     */
    public UpdateTaskRequestDto withStatus(UpdateTaskRequestDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status to apply to this Task
     */
    public UpdateTaskRequestDto withStatus(JsonNullable<? extends UpdateTaskRequestDtoStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateTaskRequestDto other = (UpdateTaskRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.comment, other.comment) &&
            Utils.enhancedDeepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            comment, status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateTaskRequestDto.class,
                "comment", comment,
                "status", status);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> comment = JsonNullable.undefined();

        private JsonNullable<? extends UpdateTaskRequestDtoStatus> status = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Comment or note about the task update
         */
        public Builder comment(String comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = JsonNullable.of(comment);
            return this;
        }

        /**
         * Comment or note about the task update
         */
        public Builder comment(JsonNullable<String> comment) {
            Utils.checkNotNull(comment, "comment");
            this.comment = comment;
            return this;
        }


        /**
         * The status to apply to this Task
         */
        public Builder status(UpdateTaskRequestDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status to apply to this Task
         */
        public Builder status(JsonNullable<? extends UpdateTaskRequestDtoStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public UpdateTaskRequestDto build() {

            return new UpdateTaskRequestDto(
                comment, status);
        }

    }
}
