/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * HRISBankDetailsAccountTypeValue
 * 
 * <p>The type of bank account
 */
@JsonDeserialize(using = HRISBankDetailsAccountTypeValue._Deserializer.class)
@JsonSerialize(using = HRISBankDetailsAccountTypeValue._Serializer.class)
public class HRISBankDetailsAccountTypeValue {

    public static final HRISBankDetailsAccountTypeValue SAVINGS = new HRISBankDetailsAccountTypeValue("savings");
    public static final HRISBankDetailsAccountTypeValue CHECKING = new HRISBankDetailsAccountTypeValue("checking");
    public static final HRISBankDetailsAccountTypeValue CURRENT = new HRISBankDetailsAccountTypeValue("current");
    public static final HRISBankDetailsAccountTypeValue BUSINESS = new HRISBankDetailsAccountTypeValue("business");
    public static final HRISBankDetailsAccountTypeValue PERSONAL = new HRISBankDetailsAccountTypeValue("personal");
    public static final HRISBankDetailsAccountTypeValue OTHER = new HRISBankDetailsAccountTypeValue("other");
    public static final HRISBankDetailsAccountTypeValue UNMAPPED_VALUE = new HRISBankDetailsAccountTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISBankDetailsAccountTypeValue> values = createValuesMap();
    private static final Map<String, HRISBankDetailsAccountTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISBankDetailsAccountTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISBankDetailsAccountTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISBankDetailsAccountTypeValue
     */ 
    public static HRISBankDetailsAccountTypeValue of(String value) {
        synchronized (HRISBankDetailsAccountTypeValue.class) {
            return values.computeIfAbsent(value, v -> new HRISBankDetailsAccountTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<HRISBankDetailsAccountTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISBankDetailsAccountTypeValue other = (HRISBankDetailsAccountTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISBankDetailsAccountTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISBankDetailsAccountTypeValue[] values() {
        synchronized (HRISBankDetailsAccountTypeValue.class) {
            return values.values().toArray(new HRISBankDetailsAccountTypeValue[] {});
        }
    }

    private static final Map<String, HRISBankDetailsAccountTypeValue> createValuesMap() {
        Map<String, HRISBankDetailsAccountTypeValue> map = new LinkedHashMap<>();
        map.put("savings", SAVINGS);
        map.put("checking", CHECKING);
        map.put("current", CURRENT);
        map.put("business", BUSINESS);
        map.put("personal", PERSONAL);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISBankDetailsAccountTypeValueEnum> createEnumsMap() {
        Map<String, HRISBankDetailsAccountTypeValueEnum> map = new HashMap<>();
        map.put("savings", HRISBankDetailsAccountTypeValueEnum.SAVINGS);
        map.put("checking", HRISBankDetailsAccountTypeValueEnum.CHECKING);
        map.put("current", HRISBankDetailsAccountTypeValueEnum.CURRENT);
        map.put("business", HRISBankDetailsAccountTypeValueEnum.BUSINESS);
        map.put("personal", HRISBankDetailsAccountTypeValueEnum.PERSONAL);
        map.put("other", HRISBankDetailsAccountTypeValueEnum.OTHER);
        map.put("unmapped_value", HRISBankDetailsAccountTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<HRISBankDetailsAccountTypeValue> {

        protected _Serializer() {
            super(HRISBankDetailsAccountTypeValue.class);
        }

        @Override
        public void serialize(HRISBankDetailsAccountTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<HRISBankDetailsAccountTypeValue> {

        protected _Deserializer() {
            super(HRISBankDetailsAccountTypeValue.class);
        }

        @Override
        public HRISBankDetailsAccountTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return HRISBankDetailsAccountTypeValue.of(v);
        }
    }
    
    public enum HRISBankDetailsAccountTypeValueEnum {

        SAVINGS("savings"),
        CHECKING("checking"),
        CURRENT("current"),
        BUSINESS("business"),
        PERSONAL("personal"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HRISBankDetailsAccountTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

