/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class ProviderError {
    /**
     * HTTP status code of the provider error
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<Double> status;

    /**
     * URL that caused the error
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * Raw error response from the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("raw")
    private JsonNullable<? extends Raw> raw;

    /**
     * Response headers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Headers> headers;

    @JsonCreator
    public ProviderError(
            @JsonProperty("status") JsonNullable<Double> status,
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("raw") JsonNullable<? extends Raw> raw,
            @JsonProperty("headers") JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(headers, "headers");
        this.status = status;
        this.url = url;
        this.raw = raw;
        this.headers = headers;
    }
    
    public ProviderError() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * HTTP status code of the provider error
     */
    @JsonIgnore
    public JsonNullable<Double> status() {
        return status;
    }

    /**
     * URL that caused the error
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * Raw error response from the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Raw> raw() {
        return (JsonNullable<Raw>) raw;
    }

    /**
     * Response headers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Headers> headers() {
        return (JsonNullable<Headers>) headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP status code of the provider error
     */
    public ProviderError withStatus(double status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * HTTP status code of the provider error
     */
    public ProviderError withStatus(JsonNullable<Double> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * URL that caused the error
     */
    public ProviderError withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * URL that caused the error
     */
    public ProviderError withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * Raw error response from the provider
     */
    public ProviderError withRaw(Raw raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    /**
     * Raw error response from the provider
     */
    public ProviderError withRaw(JsonNullable<? extends Raw> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    /**
     * Response headers
     */
    public ProviderError withHeaders(Headers headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    /**
     * Response headers
     */
    public ProviderError withHeaders(JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderError other = (ProviderError) o;
        return 
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.raw, other.raw) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            status, url, raw,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ProviderError.class,
                "status", status,
                "url", url,
                "raw", raw,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<Double> status = JsonNullable.undefined();

        private JsonNullable<String> url = JsonNullable.undefined();

        private JsonNullable<? extends Raw> raw = JsonNullable.undefined();

        private JsonNullable<? extends Headers> headers = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP status code of the provider error
         */
        public Builder status(double status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * HTTP status code of the provider error
         */
        public Builder status(JsonNullable<Double> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * URL that caused the error
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * URL that caused the error
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }


        /**
         * Raw error response from the provider
         */
        public Builder raw(Raw raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        /**
         * Raw error response from the provider
         */
        public Builder raw(JsonNullable<? extends Raw> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }


        /**
         * Response headers
         */
        public Builder headers(Headers headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        /**
         * Response headers
         */
        public Builder headers(JsonNullable<? extends Headers> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public ProviderError build() {

            return new ProviderError(
                status, url, raw,
                headers);
        }

    }
}
