/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * LmsListCoursesQueryParamFilter
 * 
 * <p>LMS Courses Filter
 */
public class LmsListCoursesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Filter to select courses by external_reference
     */
    @SpeakeasyMetadata("queryParam:name=external_reference")
    private JsonNullable<String> externalReference;

    /**
     * Filter to allow filtering of only active courses
     */
    @SpeakeasyMetadata("queryParam:name=active")
    private JsonNullable<? extends Active> active;

    @JsonCreator
    public LmsListCoursesQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<String> externalReference,
            JsonNullable<? extends Active> active) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(active, "active");
        this.updatedAfter = updatedAfter;
        this.externalReference = externalReference;
        this.active = active;
    }
    
    public LmsListCoursesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select courses by external_reference
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * Filter to allow filtering of only active courses
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Active> active() {
        return (JsonNullable<Active>) active;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListCoursesQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListCoursesQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select courses by external_reference
     */
    public LmsListCoursesQueryParamFilter withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * Filter to select courses by external_reference
     */
    public LmsListCoursesQueryParamFilter withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * Filter to allow filtering of only active courses
     */
    public LmsListCoursesQueryParamFilter withActive(Active active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Filter to allow filtering of only active courses
     */
    public LmsListCoursesQueryParamFilter withActive(JsonNullable<? extends Active> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListCoursesQueryParamFilter other = (LmsListCoursesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference) &&
            Utils.enhancedDeepEquals(this.active, other.active);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, externalReference, active);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListCoursesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "externalReference", externalReference,
                "active", active);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> externalReference = JsonNullable.undefined();

        private JsonNullable<? extends Active> active = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Filter to select courses by external_reference
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * Filter to select courses by external_reference
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }


        /**
         * Filter to allow filtering of only active courses
         */
        public Builder active(Active active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Filter to allow filtering of only active courses
         */
        public Builder active(JsonNullable<? extends Active> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }

        public LmsListCoursesQueryParamFilter build() {

            return new LmsListCoursesQueryParamFilter(
                updatedAfter, externalReference, active);
        }

    }
}
