/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.WorkEligibilityPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeWorkEligibilityResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workEligibilityPaginated = workEligibilityPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeWorkEligibilityResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkEligibilityPaginated> workEligibilityPaginated() {
        return this.workEligibilityPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeWorkEligibilityResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withWorkEligibilityPaginated(WorkEligibilityPaginated workEligibilityPaginated) {
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        this.workEligibilityPaginated = Optional.ofNullable(workEligibilityPaginated);
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withWorkEligibilityPaginated(Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated) {
        Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
        this.workEligibilityPaginated = workEligibilityPaginated;
        return this;
    }

    public HrisListEmployeeWorkEligibilityResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeWorkEligibilityResponse other = (HrisListEmployeeWorkEligibilityResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.workEligibilityPaginated, other.workEligibilityPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeWorkEligibilityResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workEligibilityPaginated", this.workEligibilityPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workEligibilityPaginated(WorkEligibilityPaginated workEligibilityPaginated) {
            Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
            this.workEligibilityPaginated = Optional.ofNullable(workEligibilityPaginated);
            return this;
        }

        public Builder workEligibilityPaginated(Optional<? extends WorkEligibilityPaginated> workEligibilityPaginated) {
            Utils.checkNotNull(workEligibilityPaginated, "workEligibilityPaginated");
            this.workEligibilityPaginated = workEligibilityPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeWorkEligibilityResponse build() {
            return new HrisListEmployeeWorkEligibilityResponse(this.contentType, this.statusCode, this.rawResponse, this.workEligibilityPaginated, this.headers);
        }
    }
}

