/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.DownloadApiModel;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.HrisDownloadEmployeeDocumentRequest;
import com.stackone.stackone_client_java.models.operations.HrisDownloadEmployeeDocumentResponse;
import com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.AsyncRetries;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class HrisDownloadEmployeeDocument {

    public static class Async
    extends Base
    implements Operations.AsyncRequestOperation<HrisDownloadEmployeeDocumentRequest, com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(SDKConfiguration sdkConfiguration, Optional<Options> options, ScheduledExecutorService retryScheduler, Headers _headers) {
            super(sdkConfiguration, options, _headers);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(HrisDownloadEmployeeDocumentRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, HrisDownloadEmployeeDocumentRequest.class);
            return this.sdkConfiguration.asyncHooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(this.createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(HrisDownloadEmployeeDocumentRequest request) {
            AsyncRetries retries = AsyncRetries.builder().retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).scheduler(this.retryScheduler).build();
            return retries.retry(() -> ((CompletableFuture)((CompletableFuture)Exceptions.unchecked(() -> this.onBuildRequest(request)).get().thenCompose(this.client::sendAsync)).handle((resp, err) -> {
                if (err != null) {
                    return this.onError(null, (Throwable)err);
                }
                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                    return this.onError((HttpResponse<Blob>)resp, null);
                }
                return CompletableFuture.completedFuture(resp);
            })).thenCompose(Function.identity())).thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse> handleResponse(HttpResponse<Blob> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            HrisDownloadEmployeeDocumentResponse.Builder resBuilder = com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/gzip")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/msword")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/pdf")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/rtf")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-excel")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-outlook")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-powerpoint")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.presentation")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.spreadsheet")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.text")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/x-7z-compressed")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/x-rar-compressed")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/xml")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "application/zip")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "audio/mp4")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "audio/mpeg")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "audio/wav")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/bmp")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/gif")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/heic")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/jpeg")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/png")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/tiff")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "image/webp")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "message/rfc822")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "text/csv")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "text/html")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "text/rtf")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "video/avi")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "video/mp4")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "video/quicktime")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "video/webm")) {
                    return CompletableFuture.completedFuture(res);
                }
                if (Utils.contentTypeMatches(contentType, "text/plain")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        try {
                            String out = new String((byte[])bodyBytes, StandardCharsets.UTF_8);
                            res.withDownloadApiModel(out);
                            return res;
                        }
                        catch (Exception e) {
                            return (com.stackone.stackone_client_java.models.operations.async.HrisDownloadEmployeeDocumentResponse)Exceptions.rethrow(e);
                        }
                    });
                }
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return Utils.unmarshalAsync(response, new TypeReference<DownloadApiModel>(){}).thenApply(res::withDownloadApiModel1);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadRequestResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnauthorizedResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ForbiddenResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotFoundResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return RequestTimedOutResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return ConflictResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return PreconditionFailedResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return UnprocessableEntityResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return TooManyRequestsResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return InternalServerErrorResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return NotImplementedResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return BadGatewayResponse.fromAsync(response).thenCompose(CompletableFuture::failedFuture);
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }

    public static class Sync
    extends Base
    implements Operations.RequestOperation<HrisDownloadEmployeeDocumentRequest, HrisDownloadEmployeeDocumentResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            super(sdkConfiguration, options, _headers);
        }

        private HttpRequest onBuildRequest(HrisDownloadEmployeeDocumentRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, HrisDownloadEmployeeDocumentRequest.class);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(HrisDownloadEmployeeDocumentRequest request) {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "412", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return Exceptions.unchecked(() -> this.onSuccess(retries.run())).get();
        }

        @Override
        public HrisDownloadEmployeeDocumentResponse handleResponse(HttpResponse<InputStream> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            HrisDownloadEmployeeDocumentResponse.Builder resBuilder = HrisDownloadEmployeeDocumentResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            HrisDownloadEmployeeDocumentResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/gzip")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/msword")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/pdf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/rtf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-excel")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-outlook")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.ms-powerpoint")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.presentation")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.spreadsheet")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.oasis.opendocument.text")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/x-7z-compressed")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/x-rar-compressed")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/xml")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/zip")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/mp4")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/mpeg")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "audio/wav")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/bmp")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/gif")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/heic")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/jpeg")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/png")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/tiff")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "image/webp")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "message/rfc822")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/csv")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/html")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/rtf")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/avi")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/mp4")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/quicktime")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "video/webm")) {
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "text/plain")) {
                    String out = Exceptions.unchecked(() -> Utils.toUtf8AndClose((InputStream)response.body())).get();
                    res.withDownloadApiModel(out);
                    return res;
                }
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return res.withDownloadApiModel1(Utils.unmarshal(response, new TypeReference<DownloadApiModel>(){}));
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadRequestResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnauthorizedResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ForbiddenResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotFoundResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw RequestTimedOutResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw ConflictResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "412")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw PreconditionFailedResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw UnprocessableEntityResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw TooManyRequestsResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw InternalServerErrorResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw NotImplementedResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    throw BadGatewayResponse.from(response);
                }
                throw SDKError.from("Unexpected content-type received: " + contentType, response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw SDKError.from("API error occurred", response);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw SDKError.from("API error occurred", response);
            }
            throw SDKError.from("Unexpected status code received: " + response.statusCode(), response);
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;
        final Headers _headers;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options, Headers _headers) {
            this.sdkConfiguration = sdkConfiguration;
            this._headers = _headers;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.empty(), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.empty(), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.empty(), this.securitySource());
        }

        <T> HttpRequest buildRequest(T request, Class<T> klass) throws Exception {
            String url = Utils.generateURL(klass, this.baseUrl, "/unified/hris/employees/{id}/documents/{subResourceId}/download", request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json;q=1, text/csv;q=0.97, text/plain;q=0.95, application/gzip;q=0.92, application/msword;q=0.89, application/octet-stream;q=0.87, application/pdf;q=0.84, application/rtf;q=0.82, application/vnd.ms-excel;q=0.79, application/vnd.ms-outlook;q=0.76, application/vnd.ms-powerpoint;q=0.74, application/vnd.oasis.opendocument.presentation;q=0.71, application/vnd.oasis.opendocument.spreadsheet;q=0.68, application/vnd.oasis.opendocument.text;q=0.66, application/vnd.openxmlformats-officedocument.presentationml.presentation;q=0.63, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;q=0.61, application/vnd.openxmlformats-officedocument.wordprocessingml.document;q=0.58, application/x-7z-compressed;q=0.55, application/x-rar-compressed;q=0.53, application/xml;q=0.50, application/zip;q=0.47, audio/mp4;q=0.45, audio/mpeg;q=0.42, audio/wav;q=0.39, image/bmp;q=0.37, image/gif;q=0.34, image/heic;q=0.32, image/jpeg;q=0.29, image/png;q=0.26, image/tiff;q=0.24, image/webp;q=0.21, message/rfc822;q=0.18, text/html;q=0.16, text/rtf;q=0.13, video/avi;q=0.11, video/mp4;q=0.08, video/quicktime;q=0.05, video/webm;q=0").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            this._headers.forEach((k, list) -> list.forEach(v -> req.addHeader((String)k, (String)v)));
            req.addQueryParams(Utils.getQueryParams(klass, request, null));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

