/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.AsyncHook;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Hooks;
import com.stackone.stackone_client_java.utils.SpeakeasyLogger;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncHooks
implements AsyncHook.BeforeRequest,
AsyncHook.AfterSuccess,
AsyncHook.AfterError {
    private static final SpeakeasyLogger logger = SpeakeasyLogger.getLogger(AsyncHooks.class);
    private final List<AsyncHook.BeforeRequest> beforeRequestHooks = new CopyOnWriteArrayList<AsyncHook.BeforeRequest>();
    private final List<AsyncHook.AfterSuccess> afterSuccessHooks = new CopyOnWriteArrayList<AsyncHook.AfterSuccess>();
    private final List<AsyncHook.AfterError> afterErrorHooks = new CopyOnWriteArrayList<AsyncHook.AfterError>();

    public AsyncHooks registerBeforeRequest(AsyncHook.BeforeRequest beforeRequest) {
        Utils.checkNotNull(beforeRequest, "beforeRequest");
        this.beforeRequestHooks.add(beforeRequest);
        logger.debug("Registered async BeforeRequest hook: {} (total: {})", (Object)beforeRequest.getClass().getSimpleName(), (Object)this.beforeRequestHooks.size());
        return this;
    }

    public AsyncHooks registerAfterSuccess(AsyncHook.AfterSuccess afterSuccess) {
        Utils.checkNotNull(afterSuccess, "afterSuccess");
        this.afterSuccessHooks.add(afterSuccess);
        logger.debug("Registered async AfterSuccess hook: {} (total: {})", (Object)afterSuccess.getClass().getSimpleName(), (Object)this.afterSuccessHooks.size());
        return this;
    }

    public AsyncHooks registerAfterError(AsyncHook.AfterError afterError) {
        Utils.checkNotNull(afterError, "afterError");
        this.afterErrorHooks.add(afterError);
        logger.debug("Registered async AfterError hook: {} (total: {})", (Object)afterError.getClass().getSimpleName(), (Object)this.afterErrorHooks.size());
        return this;
    }

    @Override
    public CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(request, "request");
        if (logger.isTraceEnabled() && !this.beforeRequestHooks.isEmpty()) {
            logger.trace("Executing {} async beforeRequest hook(s) for operation: {}", (Object)this.beforeRequestHooks.size(), (Object)context.operationId());
        }
        CompletionStage<HttpRequest> result = CompletableFuture.completedFuture(request);
        for (AsyncHook.BeforeRequest hook : this.beforeRequestHooks) {
            result = result.thenCompose(req -> hook.beforeRequest(context, (HttpRequest)req));
        }
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterSuccess(Hook.AfterSuccessContext context, HttpResponse<Blob> response) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(response, "response");
        if (logger.isTraceEnabled() && !this.afterSuccessHooks.isEmpty()) {
            logger.trace("Executing {} async afterSuccess hook(s) for operation: {}", (Object)this.afterSuccessHooks.size(), (Object)context.operationId());
        }
        CompletionStage<HttpResponse<Blob>> result = CompletableFuture.completedFuture(response);
        for (AsyncHook.AfterSuccess hook : this.afterSuccessHooks) {
            result = ((CompletableFuture)result.handle((resp, ex) -> hook.afterSuccess(context, (HttpResponse<Blob>)resp).thenApply(hookResp -> {
                if (hookResp == null) {
                    throw new IllegalStateException("afterSuccess must return a non-null response");
                }
                return hookResp;
            }))).thenCompose(future -> future);
        }
        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterError(Hook.AfterErrorContext context, HttpResponse<Blob> response, Throwable error) {
        Utils.checkNotNull(context, "context");
        Utils.checkArgument(response != null ^ error != null, "one and only one of response or error must be present");
        if (logger.isTraceEnabled() && !this.afterErrorHooks.isEmpty()) {
            logger.trace("Executing {} async afterError hook(s) for operation: {}", (Object)this.afterErrorHooks.size(), (Object)context.operationId());
        }
        CompletionStage<HttpResponse<Blob>> result = response != null ? CompletableFuture.completedFuture(response) : CompletableFuture.failedFuture(error);
        AtomicBoolean failedEarly = new AtomicBoolean(false);
        for (AsyncHook.AfterError hook : this.afterErrorHooks) {
            result = ((CompletableFuture)result.handle((resp, ex) -> {
                if (failedEarly.get()) {
                    throw (Hooks.FailEarlyException)ex;
                }
                return hook.afterError(context, (HttpResponse<Blob>)resp, (Throwable)ex).handle((hookResp, hookErr) -> {
                    if (hookErr != null) {
                        if (hookErr instanceof Hooks.FailEarlyException) {
                            failedEarly.set(true);
                            throw (Hooks.FailEarlyException)hookErr;
                        }
                        logger.debug("Async hook threw exception: {}", (Object)hookErr.getClass().getSimpleName());
                        throw Exceptions.unchecked(hookErr);
                    }
                    if (hookResp == null) {
                        throw new IllegalStateException("afterError must either throw an exception or return a non-null response");
                    }
                    return hookResp;
                });
            })).thenCompose(future -> future);
        }
        return result;
    }
}

