/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class StackoneListLogsRequest {
    /**
     * The field to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_by")
    private JsonNullable<? extends QueryParamOrderBy> orderBy;

    /**
     * The direction to order the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=order_direction")
    private JsonNullable<? extends QueryParamOrderDirection> orderDirection;

    /**
     * The number of results per page (default value is 25)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<Double> pageSize;

    /**
     * The unified cursor
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=next")
    private JsonNullable<String> next;

    /**
     * The include parameter allows you to include additional data in the response.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=include")
    private JsonNullable<? extends QueryParamInclude> include;

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=filter")
    private JsonNullable<? extends QueryParamFilter> filter;

    @JsonCreator
    public StackoneListLogsRequest(
            JsonNullable<? extends QueryParamOrderBy> orderBy,
            JsonNullable<? extends QueryParamOrderDirection> orderDirection,
            JsonNullable<Double> pageSize,
            JsonNullable<String> next,
            JsonNullable<? extends QueryParamInclude> include,
            JsonNullable<? extends QueryParamFilter> filter) {
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(orderDirection, "orderDirection");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(next, "next");
        Utils.checkNotNull(include, "include");
        Utils.checkNotNull(filter, "filter");
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
        this.pageSize = pageSize;
        this.next = next;
        this.include = include;
        this.filter = filter;
    }
    
    public StackoneListLogsRequest() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The field to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QueryParamOrderBy> orderBy() {
        return (JsonNullable<QueryParamOrderBy>) orderBy;
    }

    /**
     * The direction to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QueryParamOrderDirection> orderDirection() {
        return (JsonNullable<QueryParamOrderDirection>) orderDirection;
    }

    /**
     * The number of results per page (default value is 25)
     */
    @JsonIgnore
    public JsonNullable<Double> pageSize() {
        return pageSize;
    }

    /**
     * The unified cursor
     */
    @JsonIgnore
    public JsonNullable<String> next() {
        return next;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QueryParamInclude> include() {
        return (JsonNullable<QueryParamInclude>) include;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<QueryParamFilter> filter() {
        return (JsonNullable<QueryParamFilter>) filter;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The field to order the results by.
     */
    public StackoneListLogsRequest withOrderBy(QueryParamOrderBy orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = JsonNullable.of(orderBy);
        return this;
    }

    /**
     * The field to order the results by.
     */
    public StackoneListLogsRequest withOrderBy(JsonNullable<? extends QueryParamOrderBy> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListLogsRequest withOrderDirection(QueryParamOrderDirection orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = JsonNullable.of(orderDirection);
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListLogsRequest withOrderDirection(JsonNullable<? extends QueryParamOrderDirection> orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = orderDirection;
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListLogsRequest withPageSize(double pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public StackoneListLogsRequest withPageSize(JsonNullable<Double> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListLogsRequest withNext(String next) {
        Utils.checkNotNull(next, "next");
        this.next = JsonNullable.of(next);
        return this;
    }

    /**
     * The unified cursor
     */
    public StackoneListLogsRequest withNext(JsonNullable<String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    public StackoneListLogsRequest withInclude(QueryParamInclude include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of(include);
        return this;
    }

    /**
     * The include parameter allows you to include additional data in the response.
     */
    public StackoneListLogsRequest withInclude(JsonNullable<? extends QueryParamInclude> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListLogsRequest withFilter(QueryParamFilter filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = JsonNullable.of(filter);
        return this;
    }

    /**
     * Filter parameters that allow greater customisation of the list response
     */
    public StackoneListLogsRequest withFilter(JsonNullable<? extends QueryParamFilter> filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListLogsRequest other = (StackoneListLogsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.orderBy, other.orderBy) &&
            Utils.enhancedDeepEquals(this.orderDirection, other.orderDirection) &&
            Utils.enhancedDeepEquals(this.pageSize, other.pageSize) &&
            Utils.enhancedDeepEquals(this.next, other.next) &&
            Utils.enhancedDeepEquals(this.include, other.include) &&
            Utils.enhancedDeepEquals(this.filter, other.filter);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            orderBy, orderDirection, pageSize,
            next, include, filter);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListLogsRequest.class,
                "orderBy", orderBy,
                "orderDirection", orderDirection,
                "pageSize", pageSize,
                "next", next,
                "include", include,
                "filter", filter);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends QueryParamOrderBy> orderBy = JsonNullable.undefined();

        private JsonNullable<? extends QueryParamOrderDirection> orderDirection = JsonNullable.undefined();

        private JsonNullable<Double> pageSize = JsonNullable.undefined();

        private JsonNullable<String> next = JsonNullable.undefined();

        private JsonNullable<? extends QueryParamInclude> include = JsonNullable.undefined();

        private JsonNullable<? extends QueryParamFilter> filter = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The field to order the results by.
         */
        public Builder orderBy(QueryParamOrderBy orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = JsonNullable.of(orderBy);
            return this;
        }

        /**
         * The field to order the results by.
         */
        public Builder orderBy(JsonNullable<? extends QueryParamOrderBy> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }


        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(QueryParamOrderDirection orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = JsonNullable.of(orderDirection);
            return this;
        }

        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(JsonNullable<? extends QueryParamOrderDirection> orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = orderDirection;
            return this;
        }


        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(double pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(JsonNullable<Double> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }


        /**
         * The unified cursor
         */
        public Builder next(String next) {
            Utils.checkNotNull(next, "next");
            this.next = JsonNullable.of(next);
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(JsonNullable<String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }


        /**
         * The include parameter allows you to include additional data in the response.
         */
        public Builder include(QueryParamInclude include) {
            Utils.checkNotNull(include, "include");
            this.include = JsonNullable.of(include);
            return this;
        }

        /**
         * The include parameter allows you to include additional data in the response.
         */
        public Builder include(JsonNullable<? extends QueryParamInclude> include) {
            Utils.checkNotNull(include, "include");
            this.include = include;
            return this;
        }


        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(QueryParamFilter filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = JsonNullable.of(filter);
            return this;
        }

        /**
         * Filter parameters that allow greater customisation of the list response
         */
        public Builder filter(JsonNullable<? extends QueryParamFilter> filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = filter;
            return this;
        }

        public StackoneListLogsRequest build() {

            return new StackoneListLogsRequest(
                orderBy, orderDirection, pageSize,
                next, include, filter);
        }

    }
}
