/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CreateAnswerValue - The type of the answer.
 */
@JsonDeserialize(using = CreateAnswerValue._Deserializer.class)
@JsonSerialize(using = CreateAnswerValue._Serializer.class)
public class CreateAnswerValue {

    public static final CreateAnswerValue SHORT_TEXT = new CreateAnswerValue("short_text");
    public static final CreateAnswerValue LONG_TEXT = new CreateAnswerValue("long_text");
    public static final CreateAnswerValue ATTACHMENT = new CreateAnswerValue("attachment");
    public static final CreateAnswerValue MULTI_SELECT = new CreateAnswerValue("multi_select");
    public static final CreateAnswerValue SINGLE_SELECT = new CreateAnswerValue("single_select");
    public static final CreateAnswerValue BOOLEAN = new CreateAnswerValue("boolean");
    public static final CreateAnswerValue NUMBER = new CreateAnswerValue("number");
    public static final CreateAnswerValue DATE = new CreateAnswerValue("date");
    public static final CreateAnswerValue VIDEO = new CreateAnswerValue("video");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateAnswerValue> values = createValuesMap();
    private static final Map<String, CreateAnswerValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateAnswerValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateAnswerValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateAnswerValue
     */ 
    public static CreateAnswerValue of(String value) {
        synchronized (CreateAnswerValue.class) {
            return values.computeIfAbsent(value, v -> new CreateAnswerValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CreateAnswerValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateAnswerValue other = (CreateAnswerValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateAnswerValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateAnswerValue[] values() {
        synchronized (CreateAnswerValue.class) {
            return values.values().toArray(new CreateAnswerValue[] {});
        }
    }

    private static final Map<String, CreateAnswerValue> createValuesMap() {
        Map<String, CreateAnswerValue> map = new LinkedHashMap<>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        return map;
    }

    private static final Map<String, CreateAnswerValueEnum> createEnumsMap() {
        Map<String, CreateAnswerValueEnum> map = new HashMap<>();
        map.put("short_text", CreateAnswerValueEnum.SHORT_TEXT);
        map.put("long_text", CreateAnswerValueEnum.LONG_TEXT);
        map.put("attachment", CreateAnswerValueEnum.ATTACHMENT);
        map.put("multi_select", CreateAnswerValueEnum.MULTI_SELECT);
        map.put("single_select", CreateAnswerValueEnum.SINGLE_SELECT);
        map.put("boolean", CreateAnswerValueEnum.BOOLEAN);
        map.put("number", CreateAnswerValueEnum.NUMBER);
        map.put("date", CreateAnswerValueEnum.DATE);
        map.put("video", CreateAnswerValueEnum.VIDEO);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CreateAnswerValue> {

        protected _Serializer() {
            super(CreateAnswerValue.class);
        }

        @Override
        public void serialize(CreateAnswerValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CreateAnswerValue> {

        protected _Deserializer() {
            super(CreateAnswerValue.class);
        }

        @Override
        public CreateAnswerValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CreateAnswerValue.of(v);
        }
    }
    
    public enum CreateAnswerValueEnum {

        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),;

        private final String value;

        private CreateAnswerValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
