/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Field {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The label of the field
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The type of the field
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends FieldType> type;

    /**
     * The possible values for the field
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("values")
    private JsonNullable<? extends List<String>> values;

    /**
     * Indicates if the field is required
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("required")
    private JsonNullable<? extends Required> required;

    @JsonCreator
    public Field(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("type") JsonNullable<? extends FieldType> type,
            @JsonProperty("values") JsonNullable<? extends List<String>> values,
            @JsonProperty("required") JsonNullable<? extends Required> required) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(values, "values");
        Utils.checkNotNull(required, "required");
        this.id = id;
        this.remoteId = remoteId;
        this.label = label;
        this.type = type;
        this.values = values;
        this.required = required;
    }
    
    public Field() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The label of the field
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The type of the field
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FieldType> type() {
        return (JsonNullable<FieldType>) type;
    }

    /**
     * The possible values for the field
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> values() {
        return (JsonNullable<List<String>>) values;
    }

    /**
     * Indicates if the field is required
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Required> required() {
        return (JsonNullable<Required>) required;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public Field withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Field withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Field withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Field withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The label of the field
     */
    public Field withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The label of the field
     */
    public Field withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The type of the field
     */
    public Field withType(FieldType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the field
     */
    public Field withType(JsonNullable<? extends FieldType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The possible values for the field
     */
    public Field withValues(List<String> values) {
        Utils.checkNotNull(values, "values");
        this.values = JsonNullable.of(values);
        return this;
    }

    /**
     * The possible values for the field
     */
    public Field withValues(JsonNullable<? extends List<String>> values) {
        Utils.checkNotNull(values, "values");
        this.values = values;
        return this;
    }

    /**
     * Indicates if the field is required
     */
    public Field withRequired(Required required) {
        Utils.checkNotNull(required, "required");
        this.required = JsonNullable.of(required);
        return this;
    }

    /**
     * Indicates if the field is required
     */
    public Field withRequired(JsonNullable<? extends Required> required) {
        Utils.checkNotNull(required, "required");
        this.required = required;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Field other = (Field) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.label, other.label) &&
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.values, other.values) &&
            Objects.deepEquals(this.required, other.required);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            label,
            type,
            values,
            required);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Field.class,
                "id", id,
                "remoteId", remoteId,
                "label", label,
                "type", type,
                "values", values,
                "required", required);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private JsonNullable<? extends FieldType> type = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> values = JsonNullable.undefined();
 
        private JsonNullable<? extends Required> required = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * The label of the field
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The label of the field
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        /**
         * The type of the field
         */
        public Builder type(FieldType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the field
         */
        public Builder type(JsonNullable<? extends FieldType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * The possible values for the field
         */
        public Builder values(List<String> values) {
            Utils.checkNotNull(values, "values");
            this.values = JsonNullable.of(values);
            return this;
        }

        /**
         * The possible values for the field
         */
        public Builder values(JsonNullable<? extends List<String>> values) {
            Utils.checkNotNull(values, "values");
            this.values = values;
            return this;
        }

        /**
         * Indicates if the field is required
         */
        public Builder required(Required required) {
            Utils.checkNotNull(required, "required");
            this.required = JsonNullable.of(required);
            return this;
        }

        /**
         * Indicates if the field is required
         */
        public Builder required(JsonNullable<? extends Required> required) {
            Utils.checkNotNull(required, "required");
            this.required = required;
            return this;
        }
        
        public Field build() {
            return new Field(
                id,
                remoteId,
                label,
                type,
                values,
                required);
        }
    }
}

