/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JobsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class HrisListJobsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends JobsPaginated> jobsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<HrisListJobsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public HrisListJobsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends JobsPaginated> jobsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jobsPaginated, "jobsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jobsPaginated = jobsPaginated;
        this.headers = headers;
    }

    public HrisListJobsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<JobsPaginated> jobsPaginated() {
        return this.jobsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<HrisListJobsResponse> next() throws Exception {
        return this.next.call();
    }

    private HrisListJobsResponse withNext(Callable<Optional<HrisListJobsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListJobsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListJobsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListJobsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListJobsResponse withJobsPaginated(JobsPaginated jobsPaginated) {
        Utils.checkNotNull(jobsPaginated, "jobsPaginated");
        this.jobsPaginated = Optional.ofNullable(jobsPaginated);
        return this;
    }

    public HrisListJobsResponse withJobsPaginated(Optional<? extends JobsPaginated> jobsPaginated) {
        Utils.checkNotNull(jobsPaginated, "jobsPaginated");
        this.jobsPaginated = jobsPaginated;
        return this;
    }

    public HrisListJobsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListJobsResponse other = (HrisListJobsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.jobsPaginated, other.jobsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.jobsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListJobsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jobsPaginated", this.jobsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<HrisListJobsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends JobsPaginated> jobsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jobsPaginated(JobsPaginated jobsPaginated) {
            Utils.checkNotNull(jobsPaginated, "jobsPaginated");
            this.jobsPaginated = Optional.ofNullable(jobsPaginated);
            return this;
        }

        public Builder jobsPaginated(Optional<? extends JobsPaginated> jobsPaginated) {
            Utils.checkNotNull(jobsPaginated, "jobsPaginated");
            this.jobsPaginated = jobsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<HrisListJobsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public HrisListJobsResponse build() {
            return new HrisListJobsResponse(this.contentType, this.statusCode, this.rawResponse, this.jobsPaginated, this.headers).withNext(this.next);
        }
    }
}

