/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * BackgroundCheckOrderValue
 * 
 * <p>The status of the application.
 */
@JsonDeserialize(using = BackgroundCheckOrderValue._Deserializer.class)
@JsonSerialize(using = BackgroundCheckOrderValue._Serializer.class)
public class BackgroundCheckOrderValue {

    public static final BackgroundCheckOrderValue ACTIVE = new BackgroundCheckOrderValue("active");
    public static final BackgroundCheckOrderValue ASSESSMENT = new BackgroundCheckOrderValue("assessment");
    public static final BackgroundCheckOrderValue BACKGROUND_CHECK = new BackgroundCheckOrderValue("background_check");
    public static final BackgroundCheckOrderValue CONVERTED = new BackgroundCheckOrderValue("converted");
    public static final BackgroundCheckOrderValue DECLINED_BY_CANDIDATE = new BackgroundCheckOrderValue("declined_by_candidate");
    public static final BackgroundCheckOrderValue HIRED = new BackgroundCheckOrderValue("hired");
    public static final BackgroundCheckOrderValue INTERVIEW = new BackgroundCheckOrderValue("interview");
    public static final BackgroundCheckOrderValue LEAD = new BackgroundCheckOrderValue("lead");
    public static final BackgroundCheckOrderValue OFFER = new BackgroundCheckOrderValue("offer");
    public static final BackgroundCheckOrderValue REFERENCE_CHECK = new BackgroundCheckOrderValue("reference_check");
    public static final BackgroundCheckOrderValue REJECTED = new BackgroundCheckOrderValue("rejected");
    public static final BackgroundCheckOrderValue REVIEW = new BackgroundCheckOrderValue("review");
    public static final BackgroundCheckOrderValue SCREEN = new BackgroundCheckOrderValue("screen");
    public static final BackgroundCheckOrderValue NEW = new BackgroundCheckOrderValue("new");
    public static final BackgroundCheckOrderValue ONBOARDING = new BackgroundCheckOrderValue("onboarding");
    public static final BackgroundCheckOrderValue CREATED = new BackgroundCheckOrderValue("created");
    public static final BackgroundCheckOrderValue ACCEPTED = new BackgroundCheckOrderValue("accepted");
    public static final BackgroundCheckOrderValue SHORT_LIST = new BackgroundCheckOrderValue("short_list");
    public static final BackgroundCheckOrderValue APPROVED = new BackgroundCheckOrderValue("approved");
    public static final BackgroundCheckOrderValue UNMAPPED_VALUE = new BackgroundCheckOrderValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, BackgroundCheckOrderValue> values = createValuesMap();
    private static final Map<String, BackgroundCheckOrderValueEnum> enums = createEnumsMap();

    private final String value;

    private BackgroundCheckOrderValue(String value) {
        this.value = value;
    }

    /**
     * Returns a BackgroundCheckOrderValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as BackgroundCheckOrderValue
     */ 
    public static BackgroundCheckOrderValue of(String value) {
        synchronized (BackgroundCheckOrderValue.class) {
            return values.computeIfAbsent(value, v -> new BackgroundCheckOrderValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<BackgroundCheckOrderValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        BackgroundCheckOrderValue other = (BackgroundCheckOrderValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "BackgroundCheckOrderValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static BackgroundCheckOrderValue[] values() {
        synchronized (BackgroundCheckOrderValue.class) {
            return values.values().toArray(new BackgroundCheckOrderValue[] {});
        }
    }

    private static final Map<String, BackgroundCheckOrderValue> createValuesMap() {
        Map<String, BackgroundCheckOrderValue> map = new LinkedHashMap<>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, BackgroundCheckOrderValueEnum> createEnumsMap() {
        Map<String, BackgroundCheckOrderValueEnum> map = new HashMap<>();
        map.put("active", BackgroundCheckOrderValueEnum.ACTIVE);
        map.put("assessment", BackgroundCheckOrderValueEnum.ASSESSMENT);
        map.put("background_check", BackgroundCheckOrderValueEnum.BACKGROUND_CHECK);
        map.put("converted", BackgroundCheckOrderValueEnum.CONVERTED);
        map.put("declined_by_candidate", BackgroundCheckOrderValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", BackgroundCheckOrderValueEnum.HIRED);
        map.put("interview", BackgroundCheckOrderValueEnum.INTERVIEW);
        map.put("lead", BackgroundCheckOrderValueEnum.LEAD);
        map.put("offer", BackgroundCheckOrderValueEnum.OFFER);
        map.put("reference_check", BackgroundCheckOrderValueEnum.REFERENCE_CHECK);
        map.put("rejected", BackgroundCheckOrderValueEnum.REJECTED);
        map.put("review", BackgroundCheckOrderValueEnum.REVIEW);
        map.put("screen", BackgroundCheckOrderValueEnum.SCREEN);
        map.put("new", BackgroundCheckOrderValueEnum.NEW);
        map.put("onboarding", BackgroundCheckOrderValueEnum.ONBOARDING);
        map.put("created", BackgroundCheckOrderValueEnum.CREATED);
        map.put("accepted", BackgroundCheckOrderValueEnum.ACCEPTED);
        map.put("short_list", BackgroundCheckOrderValueEnum.SHORT_LIST);
        map.put("approved", BackgroundCheckOrderValueEnum.APPROVED);
        map.put("unmapped_value", BackgroundCheckOrderValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<BackgroundCheckOrderValue> {

        protected _Serializer() {
            super(BackgroundCheckOrderValue.class);
        }

        @Override
        public void serialize(BackgroundCheckOrderValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<BackgroundCheckOrderValue> {

        protected _Deserializer() {
            super(BackgroundCheckOrderValue.class);
        }

        @Override
        public BackgroundCheckOrderValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return BackgroundCheckOrderValue.of(v);
        }
    }
    
    public enum BackgroundCheckOrderValueEnum {

        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private BackgroundCheckOrderValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

