/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * EmploymentJob
 * 
 * <p>The job of employee
 */
public class EmploymentJob {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Title of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The employee job description
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<? extends Description> description;

    /**
     * The owner_id of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("owner_id")
    private JsonNullable<String> ownerId;

    /**
     * The parent_id of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_id")
    private JsonNullable<String> parentId;

    @JsonCreator
    public EmploymentJob(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("description") JsonNullable<? extends Description> description,
            @JsonProperty("owner_id") JsonNullable<String> ownerId,
            @JsonProperty("parent_id") JsonNullable<String> parentId) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(ownerId, "ownerId");
        Utils.checkNotNull(parentId, "parentId");
        this.id = id;
        this.remoteId = remoteId;
        this.title = title;
        this.description = description;
        this.ownerId = ownerId;
        this.parentId = parentId;
    }
    
    public EmploymentJob() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Title of the job
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The employee job description
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Description> description() {
        return (JsonNullable<Description>) description;
    }

    /**
     * The owner_id of the job
     */
    @JsonIgnore
    public JsonNullable<String> ownerId() {
        return ownerId;
    }

    /**
     * The parent_id of the job
     */
    @JsonIgnore
    public JsonNullable<String> parentId() {
        return parentId;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public EmploymentJob withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public EmploymentJob withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public EmploymentJob withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public EmploymentJob withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Title of the job
     */
    public EmploymentJob withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * Title of the job
     */
    public EmploymentJob withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The employee job description
     */
    public EmploymentJob withDescription(Description description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The employee job description
     */
    public EmploymentJob withDescription(JsonNullable<? extends Description> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The owner_id of the job
     */
    public EmploymentJob withOwnerId(String ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = JsonNullable.of(ownerId);
        return this;
    }

    /**
     * The owner_id of the job
     */
    public EmploymentJob withOwnerId(JsonNullable<String> ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = ownerId;
        return this;
    }

    /**
     * The parent_id of the job
     */
    public EmploymentJob withParentId(String parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = JsonNullable.of(parentId);
        return this;
    }

    /**
     * The parent_id of the job
     */
    public EmploymentJob withParentId(JsonNullable<String> parentId) {
        Utils.checkNotNull(parentId, "parentId");
        this.parentId = parentId;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmploymentJob other = (EmploymentJob) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.title, other.title) &&
            Objects.deepEquals(this.description, other.description) &&
            Objects.deepEquals(this.ownerId, other.ownerId) &&
            Objects.deepEquals(this.parentId, other.parentId);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            title,
            description,
            ownerId,
            parentId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EmploymentJob.class,
                "id", id,
                "remoteId", remoteId,
                "title", title,
                "description", description,
                "ownerId", ownerId,
                "parentId", parentId);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> title = JsonNullable.undefined();
 
        private JsonNullable<? extends Description> description = JsonNullable.undefined();
 
        private JsonNullable<String> ownerId = JsonNullable.undefined();
 
        private JsonNullable<String> parentId = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Title of the job
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * Title of the job
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }

        /**
         * The employee job description
         */
        public Builder description(Description description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The employee job description
         */
        public Builder description(JsonNullable<? extends Description> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * The owner_id of the job
         */
        public Builder ownerId(String ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = JsonNullable.of(ownerId);
            return this;
        }

        /**
         * The owner_id of the job
         */
        public Builder ownerId(JsonNullable<String> ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = ownerId;
            return this;
        }

        /**
         * The parent_id of the job
         */
        public Builder parentId(String parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = JsonNullable.of(parentId);
            return this;
        }

        /**
         * The parent_id of the job
         */
        public Builder parentId(JsonNullable<String> parentId) {
            Utils.checkNotNull(parentId, "parentId");
            this.parentId = parentId;
            return this;
        }
        
        public EmploymentJob build() {
            return new EmploymentJob(
                id,
                remoteId,
                title,
                description,
                ownerId,
                parentId);
        }
    }
}
