/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.HrisListCompaniesRequest;
import com.stackone.stackone_client_java.models.operations.HrisListCompaniesResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListCompaniesRequestBuilder {
    private HrisListCompaniesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallHrisListCompanies sdk;

    public HrisListCompaniesRequestBuilder(SDKMethodInterfaces.MethodCallHrisListCompanies sdk) {
        this.sdk = sdk;
    }

    public HrisListCompaniesRequestBuilder request(HrisListCompaniesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListCompaniesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListCompaniesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListCompaniesResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listCompanies(this.request, options);
    }

    public Stream<HrisListCompaniesResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

