/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneListLinkedAccountsRequest {

    /**
     * The page number of the results to fetch
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page")
    private JsonNullable<Double> page;

    /**
     * The number of results per page
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<Double> pageSize;

    /**
     * The provider of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=provider")
    @Deprecated
    private JsonNullable<String> provider;

    /**
     * The origin owner identifier of the results to fetch
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=origin_owner_id")
    private JsonNullable<String> originOwnerId;

    /**
     * The providers list of the results to fetch
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=providers")
    private Optional<? extends List<String>> providers;

    /**
     * The providers list of the results to fetch
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=account_ids")
    private Optional<? extends List<String>> accountIds;

    /**
     * The status of the results to fetch
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=status")
    private Optional<? extends List<String>> status;

    @JsonCreator
    public StackoneListLinkedAccountsRequest(
            JsonNullable<Double> page,
            JsonNullable<Double> pageSize,
            JsonNullable<String> provider,
            JsonNullable<String> originOwnerId,
            Optional<? extends List<String>> providers,
            Optional<? extends List<String>> accountIds,
            Optional<? extends List<String>> status) {
        Utils.checkNotNull(page, "page");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(providers, "providers");
        Utils.checkNotNull(accountIds, "accountIds");
        Utils.checkNotNull(status, "status");
        this.page = page;
        this.pageSize = pageSize;
        this.provider = provider;
        this.originOwnerId = originOwnerId;
        this.providers = providers;
        this.accountIds = accountIds;
        this.status = status;
    }
    
    public StackoneListLinkedAccountsRequest() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    /**
     * The page number of the results to fetch
     */
    @JsonIgnore
    public JsonNullable<Double> page() {
        return page;
    }

    /**
     * The number of results per page
     */
    @JsonIgnore
    public JsonNullable<Double> pageSize() {
        return pageSize;
    }

    /**
     * The provider of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    /**
     * The origin owner identifier of the results to fetch
     */
    @JsonIgnore
    public JsonNullable<String> originOwnerId() {
        return originOwnerId;
    }

    /**
     * The providers list of the results to fetch
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> providers() {
        return (Optional<List<String>>) providers;
    }

    /**
     * The providers list of the results to fetch
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> accountIds() {
        return (Optional<List<String>>) accountIds;
    }

    /**
     * The status of the results to fetch
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> status() {
        return (Optional<List<String>>) status;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The page number of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withPage(double page) {
        Utils.checkNotNull(page, "page");
        this.page = JsonNullable.of(page);
        return this;
    }

    /**
     * The page number of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withPage(JsonNullable<Double> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    /**
     * The number of results per page
     */
    public StackoneListLinkedAccountsRequest withPageSize(double pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page
     */
    public StackoneListLinkedAccountsRequest withPageSize(JsonNullable<Double> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The provider of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public StackoneListLinkedAccountsRequest withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    /**
     * The provider of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public StackoneListLinkedAccountsRequest withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * The origin owner identifier of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = JsonNullable.of(originOwnerId);
        return this;
    }

    /**
     * The origin owner identifier of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withOriginOwnerId(JsonNullable<String> originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    /**
     * The providers list of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withProviders(List<String> providers) {
        Utils.checkNotNull(providers, "providers");
        this.providers = Optional.ofNullable(providers);
        return this;
    }

    /**
     * The providers list of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withProviders(Optional<? extends List<String>> providers) {
        Utils.checkNotNull(providers, "providers");
        this.providers = providers;
        return this;
    }

    /**
     * The providers list of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withAccountIds(List<String> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = Optional.ofNullable(accountIds);
        return this;
    }

    /**
     * The providers list of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withAccountIds(Optional<? extends List<String>> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = accountIds;
        return this;
    }

    /**
     * The status of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withStatus(List<String> status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }

    /**
     * The status of the results to fetch
     */
    public StackoneListLinkedAccountsRequest withStatus(Optional<? extends List<String>> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListLinkedAccountsRequest other = (StackoneListLinkedAccountsRequest) o;
        return 
            Objects.deepEquals(this.page, other.page) &&
            Objects.deepEquals(this.pageSize, other.pageSize) &&
            Objects.deepEquals(this.provider, other.provider) &&
            Objects.deepEquals(this.originOwnerId, other.originOwnerId) &&
            Objects.deepEquals(this.providers, other.providers) &&
            Objects.deepEquals(this.accountIds, other.accountIds) &&
            Objects.deepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            page,
            pageSize,
            provider,
            originOwnerId,
            providers,
            accountIds,
            status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListLinkedAccountsRequest.class,
                "page", page,
                "pageSize", pageSize,
                "provider", provider,
                "originOwnerId", originOwnerId,
                "providers", providers,
                "accountIds", accountIds,
                "status", status);
    }
    
    public final static class Builder {
 
        private JsonNullable<Double> page = JsonNullable.undefined();
 
        private JsonNullable<Double> pageSize;
 
        @Deprecated
        private JsonNullable<String> provider = JsonNullable.undefined();
 
        private JsonNullable<String> originOwnerId = JsonNullable.undefined();
 
        private Optional<? extends List<String>> providers = Optional.empty();
 
        private Optional<? extends List<String>> accountIds = Optional.empty();
 
        private Optional<? extends List<String>> status = Optional.empty();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The page number of the results to fetch
         */
        public Builder page(double page) {
            Utils.checkNotNull(page, "page");
            this.page = JsonNullable.of(page);
            return this;
        }

        /**
         * The page number of the results to fetch
         */
        public Builder page(JsonNullable<Double> page) {
            Utils.checkNotNull(page, "page");
            this.page = page;
            return this;
        }

        /**
         * The number of results per page
         */
        public Builder pageSize(double pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page
         */
        public Builder pageSize(JsonNullable<Double> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }

        /**
         * The provider of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        /**
         * The provider of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        /**
         * The origin owner identifier of the results to fetch
         */
        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = JsonNullable.of(originOwnerId);
            return this;
        }

        /**
         * The origin owner identifier of the results to fetch
         */
        public Builder originOwnerId(JsonNullable<String> originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        /**
         * The providers list of the results to fetch
         */
        public Builder providers(List<String> providers) {
            Utils.checkNotNull(providers, "providers");
            this.providers = Optional.ofNullable(providers);
            return this;
        }

        /**
         * The providers list of the results to fetch
         */
        public Builder providers(Optional<? extends List<String>> providers) {
            Utils.checkNotNull(providers, "providers");
            this.providers = providers;
            return this;
        }

        /**
         * The providers list of the results to fetch
         */
        public Builder accountIds(List<String> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = Optional.ofNullable(accountIds);
            return this;
        }

        /**
         * The providers list of the results to fetch
         */
        public Builder accountIds(Optional<? extends List<String>> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = accountIds;
            return this;
        }

        /**
         * The status of the results to fetch
         */
        public Builder status(List<String> status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * The status of the results to fetch
         */
        public Builder status(Optional<? extends List<String>> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }
        
        public StackoneListLinkedAccountsRequest build() {
            if (pageSize == null) {
                pageSize = _SINGLETON_VALUE_PageSize.value();
            }
            return new StackoneListLinkedAccountsRequest(
                page,
                pageSize,
                provider,
                originOwnerId,
                providers,
                accountIds,
                status);
        }

        private static final LazySingletonValue<JsonNullable<Double>> _SINGLETON_VALUE_PageSize =
                new LazySingletonValue<>(
                        "page_size",
                        "25",
                        new TypeReference<JsonNullable<Double>>() {});
    }
}
