/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.TaskSourceValue;
import com.stackone.stackone_client_java.models.components.TaskValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class TaskType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends TaskValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends TaskSourceValue> sourceValue;

    @JsonCreator
    public TaskType(@JsonProperty(value="value") JsonNullable<? extends TaskValue> value, @JsonProperty(value="source_value") JsonNullable<? extends TaskSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public TaskType() {
        this((JsonNullable<? extends TaskValue>)JsonNullable.undefined(), (JsonNullable<? extends TaskSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<TaskValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<TaskSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TaskType withValue(TaskValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public TaskType withValue(JsonNullable<? extends TaskValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TaskType withSourceValue(TaskSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public TaskType withSourceValue(JsonNullable<? extends TaskSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskType other = (TaskType)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(TaskType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends TaskValue> value = JsonNullable.undefined();
        private JsonNullable<? extends TaskSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(TaskValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends TaskValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TaskSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TaskSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TaskType build() {
            return new TaskType(this.value, this.sourceValue);
        }
    }
}

