/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class TimeOffBalancesPolicyValue {
    public static final TimeOffBalancesPolicyValue MINUTES = new TimeOffBalancesPolicyValue("minutes");
    public static final TimeOffBalancesPolicyValue HOURS = new TimeOffBalancesPolicyValue("hours");
    public static final TimeOffBalancesPolicyValue DAYS = new TimeOffBalancesPolicyValue("days");
    public static final TimeOffBalancesPolicyValue WEEKS = new TimeOffBalancesPolicyValue("weeks");
    public static final TimeOffBalancesPolicyValue MONTHS = new TimeOffBalancesPolicyValue("months");
    public static final TimeOffBalancesPolicyValue YEARS = new TimeOffBalancesPolicyValue("years");
    public static final TimeOffBalancesPolicyValue UNKNOWN = new TimeOffBalancesPolicyValue("unknown");
    public static final TimeOffBalancesPolicyValue UNMAPPED_VALUE = new TimeOffBalancesPolicyValue("unmapped_value");
    private static final Map<String, TimeOffBalancesPolicyValue> values = TimeOffBalancesPolicyValue.createValuesMap();
    private static final Map<String, TimeOffBalancesPolicyValueEnum> enums = TimeOffBalancesPolicyValue.createEnumsMap();
    private final String value;

    private TimeOffBalancesPolicyValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesPolicyValue of(String value) {
        Class<TimeOffBalancesPolicyValue> clazz = TimeOffBalancesPolicyValue.class;
        synchronized (TimeOffBalancesPolicyValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeOffBalancesPolicyValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<TimeOffBalancesPolicyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOffBalancesPolicyValue other = (TimeOffBalancesPolicyValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeOffBalancesPolicyValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeOffBalancesPolicyValue[] values() {
        Class<TimeOffBalancesPolicyValue> clazz = TimeOffBalancesPolicyValue.class;
        synchronized (TimeOffBalancesPolicyValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeOffBalancesPolicyValue[0]);
        }
    }

    private static final Map<String, TimeOffBalancesPolicyValue> createValuesMap() {
        LinkedHashMap<String, TimeOffBalancesPolicyValue> map = new LinkedHashMap<String, TimeOffBalancesPolicyValue>();
        map.put("minutes", MINUTES);
        map.put("hours", HOURS);
        map.put("days", DAYS);
        map.put("weeks", WEEKS);
        map.put("months", MONTHS);
        map.put("years", YEARS);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffBalancesPolicyValueEnum> createEnumsMap() {
        HashMap<String, TimeOffBalancesPolicyValueEnum> map = new HashMap<String, TimeOffBalancesPolicyValueEnum>();
        map.put("minutes", TimeOffBalancesPolicyValueEnum.MINUTES);
        map.put("hours", TimeOffBalancesPolicyValueEnum.HOURS);
        map.put("days", TimeOffBalancesPolicyValueEnum.DAYS);
        map.put("weeks", TimeOffBalancesPolicyValueEnum.WEEKS);
        map.put("months", TimeOffBalancesPolicyValueEnum.MONTHS);
        map.put("years", TimeOffBalancesPolicyValueEnum.YEARS);
        map.put("unknown", TimeOffBalancesPolicyValueEnum.UNKNOWN);
        map.put("unmapped_value", TimeOffBalancesPolicyValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeOffBalancesPolicyValueEnum {
        MINUTES("minutes"),
        HOURS("hours"),
        DAYS("days"),
        WEEKS("weeks"),
        MONTHS("months"),
        YEARS("years"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeOffBalancesPolicyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<TimeOffBalancesPolicyValue> {
        protected _Deserializer() {
            super(TimeOffBalancesPolicyValue.class);
        }

        public TimeOffBalancesPolicyValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return TimeOffBalancesPolicyValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<TimeOffBalancesPolicyValue> {
        protected _Serializer() {
            super(TimeOffBalancesPolicyValue.class);
        }

        public void serialize(TimeOffBalancesPolicyValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

