/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateApplicationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class AtsCreateApplicationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

    @JsonCreator
    public AtsCreateApplicationRequest(String xAccountId, AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.xAccountId = xAccountId;
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public AtsCreateApplicationRequestDto atsCreateApplicationRequestDto() {
        return this.atsCreateApplicationRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsCreateApplicationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsCreateApplicationRequest withAtsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
        Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
        this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsCreateApplicationRequest other = (AtsCreateApplicationRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.atsCreateApplicationRequestDto, other.atsCreateApplicationRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.atsCreateApplicationRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsCreateApplicationRequest.class, "xAccountId", this.xAccountId, "atsCreateApplicationRequestDto", this.atsCreateApplicationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private AtsCreateApplicationRequestDto atsCreateApplicationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder atsCreateApplicationRequestDto(AtsCreateApplicationRequestDto atsCreateApplicationRequestDto) {
            Utils.checkNotNull(atsCreateApplicationRequestDto, "atsCreateApplicationRequestDto");
            this.atsCreateApplicationRequestDto = atsCreateApplicationRequestDto;
            return this;
        }

        public AtsCreateApplicationRequest build() {
            return new AtsCreateApplicationRequest(this.xAccountId, this.atsCreateApplicationRequestDto);
        }
    }
}

