/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BackgroundCheckOrderPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListBackgroundCheckRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListBackgroundCheckRequestResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(backgroundCheckOrderPaginated, "backgroundCheckOrderPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.backgroundCheckOrderPaginated = backgroundCheckOrderPaginated;
        this.headers = headers;
    }

    public AtsListBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated() {
        return this.backgroundCheckOrderPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListBackgroundCheckRequestResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListBackgroundCheckRequestResponse withNext(Callable<Optional<AtsListBackgroundCheckRequestResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListBackgroundCheckRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListBackgroundCheckRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListBackgroundCheckRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListBackgroundCheckRequestResponse withBackgroundCheckOrderPaginated(BackgroundCheckOrderPaginated backgroundCheckOrderPaginated) {
        Utils.checkNotNull(backgroundCheckOrderPaginated, "backgroundCheckOrderPaginated");
        this.backgroundCheckOrderPaginated = Optional.ofNullable(backgroundCheckOrderPaginated);
        return this;
    }

    public AtsListBackgroundCheckRequestResponse withBackgroundCheckOrderPaginated(Optional<? extends BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated) {
        Utils.checkNotNull(backgroundCheckOrderPaginated, "backgroundCheckOrderPaginated");
        this.backgroundCheckOrderPaginated = backgroundCheckOrderPaginated;
        return this;
    }

    public AtsListBackgroundCheckRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListBackgroundCheckRequestResponse other = (AtsListBackgroundCheckRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.backgroundCheckOrderPaginated, other.backgroundCheckOrderPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckOrderPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListBackgroundCheckRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "backgroundCheckOrderPaginated", this.backgroundCheckOrderPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListBackgroundCheckRequestResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder backgroundCheckOrderPaginated(BackgroundCheckOrderPaginated backgroundCheckOrderPaginated) {
            Utils.checkNotNull(backgroundCheckOrderPaginated, "backgroundCheckOrderPaginated");
            this.backgroundCheckOrderPaginated = Optional.ofNullable(backgroundCheckOrderPaginated);
            return this;
        }

        public Builder backgroundCheckOrderPaginated(Optional<? extends BackgroundCheckOrderPaginated> backgroundCheckOrderPaginated) {
            Utils.checkNotNull(backgroundCheckOrderPaginated, "backgroundCheckOrderPaginated");
            this.backgroundCheckOrderPaginated = backgroundCheckOrderPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListBackgroundCheckRequestResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListBackgroundCheckRequestResponse build() {
            return new AtsListBackgroundCheckRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckOrderPaginated, this.headers).withNext(this.next);
        }
    }
}

