/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UpdateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsUpdateBackgroundCheckPackageResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends UpdateResult> updateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsUpdateBackgroundCheckPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends UpdateResult> updateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(updateResult, "updateResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.updateResult = updateResult;
        this.headers = headers;
    }

    public AtsUpdateBackgroundCheckPackageResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<UpdateResult> updateResult() {
        return this.updateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsUpdateBackgroundCheckPackageResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsUpdateBackgroundCheckPackageResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsUpdateBackgroundCheckPackageResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsUpdateBackgroundCheckPackageResponse withUpdateResult(UpdateResult updateResult) {
        Utils.checkNotNull(updateResult, "updateResult");
        this.updateResult = Optional.ofNullable(updateResult);
        return this;
    }

    public AtsUpdateBackgroundCheckPackageResponse withUpdateResult(Optional<? extends UpdateResult> updateResult) {
        Utils.checkNotNull(updateResult, "updateResult");
        this.updateResult = updateResult;
        return this;
    }

    public AtsUpdateBackgroundCheckPackageResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateBackgroundCheckPackageResponse other = (AtsUpdateBackgroundCheckPackageResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.updateResult, other.updateResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.updateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsUpdateBackgroundCheckPackageResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "updateResult", this.updateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends UpdateResult> updateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder updateResult(UpdateResult updateResult) {
            Utils.checkNotNull(updateResult, "updateResult");
            this.updateResult = Optional.ofNullable(updateResult);
            return this;
        }

        public Builder updateResult(Optional<? extends UpdateResult> updateResult) {
            Utils.checkNotNull(updateResult, "updateResult");
            this.updateResult = updateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsUpdateBackgroundCheckPackageResponse build() {
            return new AtsUpdateBackgroundCheckPackageResponse(this.contentType, this.statusCode, this.rawResponse, this.updateResult, this.headers);
        }
    }
}

