/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisDocumentsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class HrisListEmployeeDocumentsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<HrisListEmployeeDocumentsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public HrisListEmployeeDocumentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeDocumentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisDocumentsPaginated> hrisDocumentsPaginated() {
        return this.hrisDocumentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<HrisListEmployeeDocumentsResponse> next() throws Exception {
        return this.next.call();
    }

    private HrisListEmployeeDocumentsResponse withNext(Callable<Optional<HrisListEmployeeDocumentsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeDocumentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
        Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
        this.hrisDocumentsPaginated = hrisDocumentsPaginated;
        return this;
    }

    public HrisListEmployeeDocumentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeDocumentsResponse other = (HrisListEmployeeDocumentsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.hrisDocumentsPaginated, other.hrisDocumentsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeDocumentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisDocumentsPaginated", this.hrisDocumentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<HrisListEmployeeDocumentsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisDocumentsPaginated(HrisDocumentsPaginated hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = Optional.ofNullable(hrisDocumentsPaginated);
            return this;
        }

        public Builder hrisDocumentsPaginated(Optional<? extends HrisDocumentsPaginated> hrisDocumentsPaginated) {
            Utils.checkNotNull(hrisDocumentsPaginated, "hrisDocumentsPaginated");
            this.hrisDocumentsPaginated = hrisDocumentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<HrisListEmployeeDocumentsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public HrisListEmployeeDocumentsResponse build() {
            return new HrisListEmployeeDocumentsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisDocumentsPaginated, this.headers).withNext(this.next);
        }
    }
}

