/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamRolesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class IamListRolesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamRolesPaginated> iamRolesPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<IamListRolesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public IamListRolesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamRolesPaginated> iamRolesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamRolesPaginated = iamRolesPaginated;
        this.headers = headers;
    }

    public IamListRolesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamRolesPaginated> iamRolesPaginated() {
        return this.iamRolesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<IamListRolesResponse> next() throws Exception {
        return this.next.call();
    }

    private IamListRolesResponse withNext(Callable<Optional<IamListRolesResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamListRolesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamListRolesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamListRolesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamListRolesResponse withIamRolesPaginated(IamRolesPaginated iamRolesPaginated) {
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        this.iamRolesPaginated = Optional.ofNullable(iamRolesPaginated);
        return this;
    }

    public IamListRolesResponse withIamRolesPaginated(Optional<? extends IamRolesPaginated> iamRolesPaginated) {
        Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
        this.iamRolesPaginated = iamRolesPaginated;
        return this;
    }

    public IamListRolesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamListRolesResponse other = (IamListRolesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.iamRolesPaginated, other.iamRolesPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.iamRolesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(IamListRolesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamRolesPaginated", this.iamRolesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<IamListRolesResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamRolesPaginated> iamRolesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamRolesPaginated(IamRolesPaginated iamRolesPaginated) {
            Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
            this.iamRolesPaginated = Optional.ofNullable(iamRolesPaginated);
            return this;
        }

        public Builder iamRolesPaginated(Optional<? extends IamRolesPaginated> iamRolesPaginated) {
            Utils.checkNotNull(iamRolesPaginated, "iamRolesPaginated");
            this.iamRolesPaginated = iamRolesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<IamListRolesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public IamListRolesResponse build() {
            return new IamListRolesResponse(this.contentType, this.statusCode, this.rawResponse, this.iamRolesPaginated, this.headers).withNext(this.next);
        }
    }
}

