/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamUsersPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class IamListUsersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends IamUsersPaginated> iamUsersPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<IamListUsersResponse>> next = () -> Optional.empty();

    @JsonCreator
    public IamListUsersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends IamUsersPaginated> iamUsersPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamUsersPaginated = iamUsersPaginated;
        this.headers = headers;
    }

    public IamListUsersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<IamUsersPaginated> iamUsersPaginated() {
        return this.iamUsersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<IamListUsersResponse> next() throws Exception {
        return this.next.call();
    }

    private IamListUsersResponse withNext(Callable<Optional<IamListUsersResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IamListUsersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public IamListUsersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public IamListUsersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public IamListUsersResponse withIamUsersPaginated(IamUsersPaginated iamUsersPaginated) {
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        this.iamUsersPaginated = Optional.ofNullable(iamUsersPaginated);
        return this;
    }

    public IamListUsersResponse withIamUsersPaginated(Optional<? extends IamUsersPaginated> iamUsersPaginated) {
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        this.iamUsersPaginated = iamUsersPaginated;
        return this;
    }

    public IamListUsersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamListUsersResponse other = (IamListUsersResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.iamUsersPaginated, other.iamUsersPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.iamUsersPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(IamListUsersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "iamUsersPaginated", this.iamUsersPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<IamListUsersResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends IamUsersPaginated> iamUsersPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder iamUsersPaginated(IamUsersPaginated iamUsersPaginated) {
            Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
            this.iamUsersPaginated = Optional.ofNullable(iamUsersPaginated);
            return this;
        }

        public Builder iamUsersPaginated(Optional<? extends IamUsersPaginated> iamUsersPaginated) {
            Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
            this.iamUsersPaginated = iamUsersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<IamListUsersResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public IamListUsersResponse build() {
            return new IamListUsersResponse(this.contentType, this.statusCode, this.rawResponse, this.iamUsersPaginated, this.headers).withNext(this.next);
        }
    }
}

