/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ConnectorsMeta;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StackoneGetConnectorMetaResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ConnectorsMeta> connectorsMeta;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneGetConnectorMetaResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ConnectorsMeta> connectorsMeta, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.connectorsMeta = connectorsMeta;
        this.headers = headers;
    }

    public StackoneGetConnectorMetaResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ConnectorsMeta> connectorsMeta() {
        return this.connectorsMeta;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public StackoneGetConnectorMetaResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneGetConnectorMetaResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneGetConnectorMetaResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneGetConnectorMetaResponse withConnectorsMeta(ConnectorsMeta connectorsMeta) {
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        this.connectorsMeta = Optional.ofNullable(connectorsMeta);
        return this;
    }

    public StackoneGetConnectorMetaResponse withConnectorsMeta(Optional<? extends ConnectorsMeta> connectorsMeta) {
        Utils.checkNotNull(connectorsMeta, "connectorsMeta");
        this.connectorsMeta = connectorsMeta;
        return this;
    }

    public StackoneGetConnectorMetaResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneGetConnectorMetaResponse other = (StackoneGetConnectorMetaResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.connectorsMeta, other.connectorsMeta) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.connectorsMeta, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneGetConnectorMetaResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "connectorsMeta", this.connectorsMeta, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ConnectorsMeta> connectorsMeta = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder connectorsMeta(ConnectorsMeta connectorsMeta) {
            Utils.checkNotNull(connectorsMeta, "connectorsMeta");
            this.connectorsMeta = Optional.ofNullable(connectorsMeta);
            return this;
        }

        public Builder connectorsMeta(Optional<? extends ConnectorsMeta> connectorsMeta) {
            Utils.checkNotNull(connectorsMeta, "connectorsMeta");
            this.connectorsMeta = connectorsMeta;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneGetConnectorMetaResponse build() {
            return new StackoneGetConnectorMetaResponse(this.contentType, this.statusCode, this.rawResponse, this.connectorsMeta, this.headers);
        }
    }
}

