/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.operations.Include;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.models.operations.StackoneGetLogResponse;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetLogRequestBuilder {
    private String id;
    private JsonNullable<? extends Include> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallStackoneGetLog sdk;

    public StackoneGetLogRequestBuilder(SDKMethodInterfaces.MethodCallStackoneGetLog sdk) {
        this.sdk = sdk;
    }

    public StackoneGetLogRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public StackoneGetLogRequestBuilder include(Include include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)((Object)include));
        return this;
    }

    public StackoneGetLogRequestBuilder include(JsonNullable<? extends Include> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public StackoneGetLogRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneGetLogRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneGetLogResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getLog(this.id, this.include, options);
    }
}

