/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.PatchAccountExternalDto;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneDeleteAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountMetaInfoResponse;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListLinkedAccountsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequest;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneUpdateAccountResponse;
import com.stackone.stackone_client_java.operations.StackoneDeleteAccountOperation;
import com.stackone.stackone_client_java.operations.StackoneGetAccountMetaInfoOperation;
import com.stackone.stackone_client_java.operations.StackoneGetAccountOperation;
import com.stackone.stackone_client_java.operations.StackoneListLinkedAccountsOperation;
import com.stackone.stackone_client_java.operations.StackoneUpdateAccountOperation;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.lang.String;
import java.util.List;
import java.util.Optional;

/**
 * Customer or business accounts.
 */
public class Accounts {
    private final SDKConfiguration sdkConfiguration;

    Accounts(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List Accounts
     * 
     * @return The call builder
     */
    public StackoneListLinkedAccountsRequestBuilder listLinkedAccounts() {
        return new StackoneListLinkedAccountsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListLinkedAccountsResponse listLinkedAccounts(StackoneListLinkedAccountsRequest request) throws Exception {
        return listLinkedAccounts(request, Optional.empty());
    }

    /**
     * List Accounts
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListLinkedAccountsResponse listLinkedAccounts(
            StackoneListLinkedAccountsRequest request,
            Optional<Options> options) throws Exception {
        RequestOperation<StackoneListLinkedAccountsRequest, StackoneListLinkedAccountsResponse> operation
              = new StackoneListLinkedAccountsOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }


    /**
     * Get Account
     * 
     * @return The call builder
     */
    public StackoneGetAccountRequestBuilder getAccount() {
        return new StackoneGetAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Account
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountResponse getAccount(String id) throws Exception {
        return getAccount(id, Optional.empty());
    }

    /**
     * Get Account
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountResponse getAccount(
            String id,
            Optional<Options> options) throws Exception {
        StackoneGetAccountRequest request =
            StackoneGetAccountRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneGetAccountRequest, StackoneGetAccountResponse> operation
              = new StackoneGetAccountOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }


    /**
     * Delete Account
     * 
     * @return The call builder
     */
    public StackoneDeleteAccountRequestBuilder deleteAccount() {
        return new StackoneDeleteAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneDeleteAccountResponse deleteAccount(String id) throws Exception {
        return deleteAccount(id, Optional.empty());
    }

    /**
     * Delete Account
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneDeleteAccountResponse deleteAccount(
            String id,
            Optional<Options> options) throws Exception {
        StackoneDeleteAccountRequest request =
            StackoneDeleteAccountRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneDeleteAccountRequest, StackoneDeleteAccountResponse> operation
              = new StackoneDeleteAccountOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }


    /**
     * Update Account
     * 
     * @return The call builder
     */
    public StackoneUpdateAccountRequestBuilder updateAccount() {
        return new StackoneUpdateAccountRequestBuilder(sdkConfiguration);
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneUpdateAccountResponse updateAccount(
            String id,
            PatchAccountExternalDto patchAccountExternalDto) throws Exception {
        return updateAccount(id, patchAccountExternalDto, Optional.empty());
    }

    /**
     * Update Account
     * 
     * @param id 
     * @param patchAccountExternalDto 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneUpdateAccountResponse updateAccount(
            String id,
            PatchAccountExternalDto patchAccountExternalDto,
            Optional<Options> options) throws Exception {
        StackoneUpdateAccountRequest request =
            StackoneUpdateAccountRequest
                .builder()
                .id(id)
                .patchAccountExternalDto(patchAccountExternalDto)
                .build();
        RequestOperation<StackoneUpdateAccountRequest, StackoneUpdateAccountResponse> operation
              = new StackoneUpdateAccountOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }


    /**
     * Get meta information of the account
     * 
     * @return The call builder
     */
    public StackoneGetAccountMetaInfoRequestBuilder getAccountMetaInfo() {
        return new StackoneGetAccountMetaInfoRequestBuilder(sdkConfiguration);
    }

    /**
     * Get meta information of the account
     * 
     * @param id 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(String id) throws Exception {
        return getAccountMetaInfo(id, Optional.empty());
    }

    /**
     * Get meta information of the account
     * 
     * @param id 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetAccountMetaInfoResponse getAccountMetaInfo(
            String id,
            Optional<Options> options) throws Exception {
        StackoneGetAccountMetaInfoRequest request =
            StackoneGetAccountMetaInfoRequest
                .builder()
                .id(id)
                .build();
        RequestOperation<StackoneGetAccountMetaInfoRequest, StackoneGetAccountMetaInfoResponse> operation
              = new StackoneGetAccountMetaInfoOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }

}
