/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreatePackage {

    /**
     * Package name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * Package description
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    @JsonCreator
    public CreatePackage(
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        this.name = name;
        this.description = description;
    }
    
    public CreatePackage() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Package name
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Package description
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Package name
     */
    public CreatePackage withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Package name
     */
    public CreatePackage withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Package description
     */
    public CreatePackage withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * Package description
     */
    public CreatePackage withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreatePackage other = (CreatePackage) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name,
            description);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreatePackage.class,
                "name", name,
                "description", description);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Package name
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Package name
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * Package description
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * Package description
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }
        
        public CreatePackage build() {
            return new CreatePackage(
                name,
                description);
        }
    }
}
