/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * PositionStatus
 * 
 * <p>Status of the position
 */
public class PositionStatus {

    /**
     * The status of the position.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends PositionValue> value;

    /**
     * The source value of the position status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends PositionSourceValue> sourceValue;

    @JsonCreator
    public PositionStatus(
            @JsonProperty("value") JsonNullable<? extends PositionValue> value,
            @JsonProperty("source_value") JsonNullable<? extends PositionSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public PositionStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the position.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PositionValue> value() {
        return (JsonNullable<PositionValue>) value;
    }

    /**
     * The source value of the position status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PositionSourceValue> sourceValue() {
        return (JsonNullable<PositionSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The status of the position.
     */
    public PositionStatus withValue(PositionValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the position.
     */
    public PositionStatus withValue(JsonNullable<? extends PositionValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the position status.
     */
    public PositionStatus withSourceValue(PositionSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the position status.
     */
    public PositionStatus withSourceValue(JsonNullable<? extends PositionSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PositionStatus other = (PositionStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PositionStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends PositionValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends PositionSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the position.
         */
        public Builder value(PositionValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the position.
         */
        public Builder value(JsonNullable<? extends PositionValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the position status.
         */
        public Builder sourceValue(PositionSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the position status.
         */
        public Builder sourceValue(JsonNullable<? extends PositionSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public PositionStatus build() {
            return new PositionStatus(
                value,
                sourceValue);
        }
    }
}
