/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class LmsListUserAssignmentsRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=raw")
    private JsonNullable<Boolean> raw;

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=proxy")
    private JsonNullable<? extends Map<String, Object>> proxy;

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=fields")
    private JsonNullable<String> fields;

    /**
     * LMS Assignment Filter
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=filter")
    private JsonNullable<? extends LmsListUserAssignmentsQueryParamFilter> filter;

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page")
    @Deprecated
    private JsonNullable<String> page;

    /**
     * The number of results per page (default value is 25)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=page_size")
    private JsonNullable<String> pageSize;

    /**
     * The unified cursor
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=next")
    private JsonNullable<String> next;

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=updated_after")
    @Deprecated
    private JsonNullable<String> updatedAfter;

    /**
     * The user ID associated with this assignment
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=user_id")
    private JsonNullable<String> userId;

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=remote_user_id")
    private JsonNullable<String> remoteUserId;

    @JsonCreator
    public LmsListUserAssignmentsRequest(
            String xAccountId,
            String id,
            JsonNullable<Boolean> raw,
            JsonNullable<? extends Map<String, Object>> proxy,
            JsonNullable<String> fields,
            JsonNullable<? extends LmsListUserAssignmentsQueryParamFilter> filter,
            JsonNullable<String> page,
            JsonNullable<String> pageSize,
            JsonNullable<String> next,
            JsonNullable<String> updatedAfter,
            JsonNullable<String> userId,
            JsonNullable<String> remoteUserId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(proxy, "proxy");
        Utils.checkNotNull(fields, "fields");
        Utils.checkNotNull(filter, "filter");
        Utils.checkNotNull(page, "page");
        Utils.checkNotNull(pageSize, "pageSize");
        Utils.checkNotNull(next, "next");
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.xAccountId = xAccountId;
        this.id = id;
        this.raw = raw;
        this.proxy = proxy;
        this.fields = fields;
        this.filter = filter;
        this.page = page;
        this.pageSize = pageSize;
        this.next = next;
        this.updatedAfter = updatedAfter;
        this.userId = userId;
        this.remoteUserId = remoteUserId;
    }
    
    public LmsListUserAssignmentsRequest(
            String xAccountId,
            String id) {
        this(xAccountId, id, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    @JsonIgnore
    public JsonNullable<Boolean> raw() {
        return raw;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> proxy() {
        return (JsonNullable<Map<String, Object>>) proxy;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    @JsonIgnore
    public JsonNullable<String> fields() {
        return fields;
    }

    /**
     * LMS Assignment Filter
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LmsListUserAssignmentsQueryParamFilter> filter() {
        return (JsonNullable<LmsListUserAssignmentsQueryParamFilter>) filter;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> page() {
        return page;
    }

    /**
     * The number of results per page (default value is 25)
     */
    @JsonIgnore
    public JsonNullable<String> pageSize() {
        return pageSize;
    }

    /**
     * The unified cursor
     */
    @JsonIgnore
    public JsonNullable<String> next() {
        return next;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * The user ID associated with this assignment
     */
    @JsonIgnore
    public JsonNullable<String> userId() {
        return userId;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    @JsonIgnore
    public JsonNullable<String> remoteUserId() {
        return remoteUserId;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public LmsListUserAssignmentsRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsListUserAssignmentsRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public LmsListUserAssignmentsRequest withRaw(boolean raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
     */
    public LmsListUserAssignmentsRequest withRaw(JsonNullable<Boolean> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public LmsListUserAssignmentsRequest withProxy(Map<String, Object> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = JsonNullable.of(proxy);
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
     */
    public LmsListUserAssignmentsRequest withProxy(JsonNullable<? extends Map<String, Object>> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = proxy;
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public LmsListUserAssignmentsRequest withFields(String fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = JsonNullable.of(fields);
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
     */
    public LmsListUserAssignmentsRequest withFields(JsonNullable<String> fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = fields;
        return this;
    }

    /**
     * LMS Assignment Filter
     */
    public LmsListUserAssignmentsRequest withFilter(LmsListUserAssignmentsQueryParamFilter filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = JsonNullable.of(filter);
        return this;
    }

    /**
     * LMS Assignment Filter
     */
    public LmsListUserAssignmentsRequest withFilter(JsonNullable<? extends LmsListUserAssignmentsQueryParamFilter> filter) {
        Utils.checkNotNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsListUserAssignmentsRequest withPage(String page) {
        Utils.checkNotNull(page, "page");
        this.page = JsonNullable.of(page);
        return this;
    }

    /**
     * The page number of the results to fetch
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsListUserAssignmentsRequest withPage(JsonNullable<String> page) {
        Utils.checkNotNull(page, "page");
        this.page = page;
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public LmsListUserAssignmentsRequest withPageSize(String pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = JsonNullable.of(pageSize);
        return this;
    }

    /**
     * The number of results per page (default value is 25)
     */
    public LmsListUserAssignmentsRequest withPageSize(JsonNullable<String> pageSize) {
        Utils.checkNotNull(pageSize, "pageSize");
        this.pageSize = pageSize;
        return this;
    }

    /**
     * The unified cursor
     */
    public LmsListUserAssignmentsRequest withNext(String next) {
        Utils.checkNotNull(next, "next");
        this.next = JsonNullable.of(next);
        return this;
    }

    /**
     * The unified cursor
     */
    public LmsListUserAssignmentsRequest withNext(JsonNullable<String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsListUserAssignmentsRequest withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsListUserAssignmentsRequest withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * The user ID associated with this assignment
     */
    public LmsListUserAssignmentsRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = JsonNullable.of(userId);
        return this;
    }

    /**
     * The user ID associated with this assignment
     */
    public LmsListUserAssignmentsRequest withUserId(JsonNullable<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    public LmsListUserAssignmentsRequest withRemoteUserId(String remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = JsonNullable.of(remoteUserId);
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    public LmsListUserAssignmentsRequest withRemoteUserId(JsonNullable<String> remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = remoteUserId;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListUserAssignmentsRequest other = (LmsListUserAssignmentsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.raw, other.raw) &&
            Utils.enhancedDeepEquals(this.proxy, other.proxy) &&
            Utils.enhancedDeepEquals(this.fields, other.fields) &&
            Utils.enhancedDeepEquals(this.filter, other.filter) &&
            Utils.enhancedDeepEquals(this.page, other.page) &&
            Utils.enhancedDeepEquals(this.pageSize, other.pageSize) &&
            Utils.enhancedDeepEquals(this.next, other.next) &&
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.userId, other.userId) &&
            Utils.enhancedDeepEquals(this.remoteUserId, other.remoteUserId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId,
            id,
            raw,
            proxy,
            fields,
            filter,
            page,
            pageSize,
            next,
            updatedAfter,
            userId,
            remoteUserId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListUserAssignmentsRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "raw", raw,
                "proxy", proxy,
                "fields", fields,
                "filter", filter,
                "page", page,
                "pageSize", pageSize,
                "next", next,
                "updatedAfter", updatedAfter,
                "userId", userId,
                "remoteUserId", remoteUserId);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private JsonNullable<Boolean> raw = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> proxy = JsonNullable.undefined();
 
        private JsonNullable<String> fields = JsonNullable.undefined();
 
        private JsonNullable<? extends LmsListUserAssignmentsQueryParamFilter> filter = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> page = JsonNullable.undefined();
 
        private JsonNullable<String> pageSize = JsonNullable.undefined();
 
        private JsonNullable<String> next = JsonNullable.undefined();
 
        @Deprecated
        private JsonNullable<String> updatedAfter = JsonNullable.undefined();
 
        private JsonNullable<String> userId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteUserId = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(boolean raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default value is false)
         */
        public Builder raw(JsonNullable<Boolean> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(Map<String, Object> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = JsonNullable.of(proxy);
            return this;
        }

        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by surrounding them with 'proxy' key
         */
        public Builder proxy(JsonNullable<? extends Map<String, Object>> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = proxy;
            return this;
        }

        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(String fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = JsonNullable.of(fields);
            return this;
        }

        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are returned)
         */
        public Builder fields(JsonNullable<String> fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = fields;
            return this;
        }

        /**
         * LMS Assignment Filter
         */
        public Builder filter(LmsListUserAssignmentsQueryParamFilter filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = JsonNullable.of(filter);
            return this;
        }

        /**
         * LMS Assignment Filter
         */
        public Builder filter(JsonNullable<? extends LmsListUserAssignmentsQueryParamFilter> filter) {
            Utils.checkNotNull(filter, "filter");
            this.filter = filter;
            return this;
        }

        /**
         * The page number of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder page(String page) {
            Utils.checkNotNull(page, "page");
            this.page = JsonNullable.of(page);
            return this;
        }

        /**
         * The page number of the results to fetch
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder page(JsonNullable<String> page) {
            Utils.checkNotNull(page, "page");
            this.page = page;
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(String pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = JsonNullable.of(pageSize);
            return this;
        }

        /**
         * The number of results per page (default value is 25)
         */
        public Builder pageSize(JsonNullable<String> pageSize) {
            Utils.checkNotNull(pageSize, "pageSize");
            this.pageSize = pageSize;
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(String next) {
            Utils.checkNotNull(next, "next");
            this.next = JsonNullable.of(next);
            return this;
        }

        /**
         * The unified cursor
         */
        public Builder next(JsonNullable<String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }

        /**
         * The user ID associated with this assignment
         */
        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = JsonNullable.of(userId);
            return this;
        }

        /**
         * The user ID associated with this assignment
         */
        public Builder userId(JsonNullable<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        /**
         * Provider's unique identifier of the user related to the assignment
         */
        public Builder remoteUserId(String remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = JsonNullable.of(remoteUserId);
            return this;
        }

        /**
         * Provider's unique identifier of the user related to the assignment
         */
        public Builder remoteUserId(JsonNullable<String> remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = remoteUserId;
            return this;
        }
        
        public LmsListUserAssignmentsRequest build() {
            return new LmsListUserAssignmentsRequest(
                xAccountId,
                id,
                raw,
                proxy,
                fields,
                filter,
                page,
                pageSize,
                next,
                updatedAfter,
                userId,
                remoteUserId);
        }
    }
}
