/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.ClientImpl;
import com.turtlequeue.Consumer;
import com.turtlequeue.ConsumerImpl;
import com.turtlequeue.ConsumerParams;
import com.turtlequeue.EndOfTopicMessageListener;
import com.turtlequeue.MessageId;
import com.turtlequeue.SubType;
import com.turtlequeue.SubscriptionMode;
import com.turtlequeue.Topic;
import com.turtlequeue.TopicBuilderImpl;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class ConsumerBuilder {
    ClientImpl c = null;
    TopicBuilderImpl topicBuilder = null;
    EndOfTopicMessageListener endOfTopicMessageListener = null;
    String subName = null;
    String consumerName = null;
    SubType subType = null;
    Integer priority = null;
    MessageId initialPosition = null;
    Long ackTimeout = null;
    TimeUnit ackTimeoutTimeUnit = null;
    Map<String, String> metadata = null;
    Integer receiverQueueSize = null;
    SubscriptionMode subscriptionMode = null;
    String jsonPath = null;

    public ConsumerBuilder(ClientImpl c) {
        this.c = c;
        this.initialPosition = MessageId.latest;
        this.subType = SubType.Exclusive;
        this.priority = 1;
        this.metadata = Collections.emptyMap();
        this.receiverQueueSize = 1000;
        this.topicBuilder = new TopicBuilderImpl();
        this.subscriptionMode = SubscriptionMode.Durable;
    }

    public ConsumerBuilder persistent(Boolean persistent) {
        this.topicBuilder.persistent(persistent);
        return this;
    }

    public ConsumerBuilder namespace(String namespace) {
        this.topicBuilder.namespace(namespace);
        return this;
    }

    public ConsumerBuilder topic(String topic) {
        this.topicBuilder.topic(topic);
        return this;
    }

    public ConsumerBuilder topic(Topic topic) {
        this.topicBuilder.topic(topic);
        return this;
    }

    public ConsumerBuilder subscriptionName(String subName) {
        this.subName = subName;
        return this;
    }

    public ConsumerBuilder consumerName(String consumerName) {
        this.consumerName = consumerName;
        return this;
    }

    public ConsumerBuilder priorityLevel(Integer priority) {
        this.priority = priority;
        return this;
    }

    public ConsumerBuilder initialPosition(MessageId messageId) {
        this.initialPosition = messageId;
        return this;
    }

    public ConsumerBuilder metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ConsumerBuilder receiverQueueSize(Integer receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
        return this;
    }

    public ConsumerBuilder ackTimeout(long ackTimeout, TimeUnit timeUnit) {
        this.ackTimeout = ackTimeout;
        this.ackTimeoutTimeUnit = timeUnit;
        return this;
    }

    public ConsumerBuilder subscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
        return this;
    }

    public ConsumerBuilder endOfTopicMessageListener(EndOfTopicMessageListener endOfTopicMessageListener) {
        this.endOfTopicMessageListener = endOfTopicMessageListener;
        return this;
    }

    public ConsumerBuilder subscriptionType(SubType subType) {
        this.subType = subType;
        return this;
    }

    protected ConsumerBuilder jsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    private ConsumerParams getConsumerParams() {
        if (this.subName == null) {
            throw new IllegalArgumentException("subName must be specified on the ConsumerBuilder object.");
        }
        return new ConsumerParams(this.c.getNextConsumerId(), this.topicBuilder.build(), this.subName, this.consumerName, this.subType, this.priority, this.initialPosition, this.metadata, this.receiverQueueSize, this.ackTimeout, this.ackTimeoutTimeUnit, this.endOfTopicMessageListener, this.subscriptionMode, this.jsonPath);
    }

    public CompletableFuture<Consumer> subscribe() {
        return new ConsumerImpl(this.c, this.getConsumerParams()).subscribeReturn();
    }

    public ConsumerParams create() {
        return this.getConsumerParams();
    }
}

