/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.ClientImpl;
import com.turtlequeue.MessageId;
import com.turtlequeue.MessageImpl;
import com.turtlequeue.ProducerImpl;
import com.turtlequeue.ProducerParams;
import com.turtlequeue.Topic;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class MessageBuilder<T> {
    ClientImpl c = null;
    MessageId messageId = null;
    T data = null;
    String producerName = null;
    Long eventTime = null;
    Long publishTime = null;
    Topic topic = null;
    String key = null;
    Map<String, String> properties = null;
    ProducerImpl<T> producer = null;
    Boolean disableReplication = null;
    Long delay = null;
    TimeUnit delayUnit = null;

    public MessageBuilder(ProducerImpl<T> producer) {
        this.producer = producer;
        this.c = this.producer.getClient();
    }

    public MessageBuilder<T> value(T value) {
        this.data = value;
        return this;
    }

    public MessageBuilder<T> disableReplication() {
        this.disableReplication = true;
        return this;
    }

    public MessageBuilder<T> eventTime(long timestamp) {
        this.eventTime = timestamp;
        return this;
    }

    public MessageBuilder<T> key(String key) {
        this.key = key;
        return this;
    }

    public MessageBuilder<T> properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public MessageBuilder<T> property(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
        return this;
    }

    public MessageBuilder<T> deliverAfter(long delay, TimeUnit unit) {
        this.delay = delay;
        this.delayUnit = unit;
        return this;
    }

    private MessageImpl<T> build() {
        ProducerParams conf = this.producer.getConf();
        return new MessageImpl<T>(this.c, null, null, this.data, conf.getProducerName(), this.eventTime, null, conf.getTopic(), this.key, this.properties, this.producer, this.disableReplication, null, this.delay, this.delayUnit);
    }

    public CompletableFuture<MessageId> send() {
        MessageImpl<T> msg = this.build();
        return this.producer.send(msg);
    }
}

