/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.google.common.base.MoreObjects;
import com.turtlequeue.CompressionType;
import com.turtlequeue.HashingScheme;
import com.turtlequeue.Topic;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ProducerParams {
    Long producerId = null;
    Topic topic = null;
    String producerName = null;
    Boolean enableBatching = null;
    Integer batchingMaxMessages = null;
    TimeUnit batchingMaxPublishDelayUnit = null;
    Long batchingMaxPublishDelayValue = null;
    Integer maxPendingMessages = null;
    TimeUnit sendTimeoutUnit = null;
    Integer sendTimeoutValue = null;
    Map<String, String> properties = null;
    HashingScheme hashingScheme = null;
    CompressionType compressionType = null;

    public ProducerParams(Long producerId, Topic topic, String producerName, Boolean enableBatching, Integer batchingMaxMessages, TimeUnit batchingMaxPublishDelayUnit, Long batchingMaxPublishDelayValue, Integer maxPendingMessages, Map<String, String> properties, HashingScheme hashingScheme, TimeUnit sendTimeoutUnit, Integer sendTimeoutValue) {
        this.producerId = producerId;
        this.topic = topic;
        this.producerName = producerName;
        this.enableBatching = enableBatching;
        this.batchingMaxMessages = batchingMaxMessages;
        this.batchingMaxPublishDelayUnit = batchingMaxPublishDelayUnit;
        this.batchingMaxPublishDelayValue = batchingMaxPublishDelayValue;
        this.maxPendingMessages = maxPendingMessages;
        this.sendTimeoutUnit = sendTimeoutUnit;
        this.sendTimeoutValue = sendTimeoutValue;
        this.properties = properties;
        this.hashingScheme = hashingScheme;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Boolean getPersistent() {
        return this.topic.getPersistent();
    }

    public String getNamespace() {
        return this.topic.getNamespace();
    }

    public String getProducerName() {
        return this.producerName;
    }

    public Boolean getEnableBatching() {
        return this.enableBatching;
    }

    public Integer batchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public HashingScheme getHashingScheme() {
        return this.hashingScheme;
    }

    public Integer getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public TimeUnit getSendTimeoutUnit() {
        return this.sendTimeoutUnit;
    }

    public Integer getSendTimeoutValue() {
        return this.sendTimeoutValue;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerParams)) {
            return false;
        }
        ProducerParams t = (ProducerParams)o;
        return Objects.equals(this.getTopic(), t.getTopic()) && Objects.equals(this.getPersistent(), t.getPersistent()) && Objects.equals(this.getNamespace(), t.getNamespace()) && Objects.equals(this.getProducerName(), t.getProducerName()) && Objects.equals(this.getProperties(), t.getProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getPersistent(), this.getNamespace(), this.getProducerName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("producerName", (Object)this.producerName).toString();
    }
}

