/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.google.common.base.MoreObjects;
import com.turtlequeue.Topic;
import com.turtlequeue.TopicBuilderImpl;
import com.turtlequeue.sdk.api.proto.Tq;
import java.util.Objects;

public class TopicImpl
implements Topic {
    String topic = null;
    String namespace = null;
    Boolean persistent = null;

    public TopicImpl(String topic, String namespace, boolean persistent) {
        this.topic = topic;
        this.namespace = namespace;
        this.persistent = persistent;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean getPersistent() {
        return this.persistent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        Topic t = (Topic)o;
        return Objects.equals(this.getTopic(), t.getTopic()) && Objects.equals(this.getNamespace(), t.getNamespace()) && Objects.equals(this.getPersistent(), t.getPersistent());
    }

    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getNamespace(), this.getPersistent());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("persistent", (Object)this.persistent).add("namespace", (Object)this.namespace).toString();
    }

    protected static Topic fromTqTopic(Tq.Topic t) {
        return new TopicBuilderImpl().namespace(t.getNamespace()).persistent(t.getPersistent()).topic(t.getTopic()).build();
    }

    protected static Tq.Topic toTqTopic(Topic t) {
        return Tq.Topic.newBuilder().setNamespace(t.getNamespace()).setPersistent(t.getPersistent()).setTopic(t.getTopic()).build();
    }
}

