/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.format.nbs.model.NbsData;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.model.SongView;

public class NbsSong
extends Song<NbsHeader, NbsData, NbsNote> {
    public NbsSong(String fileName, NbsHeader header, NbsData data) {
        super(fileName, header, data);
    }

    @Override
    protected SongView<NbsNote> createView() {
        String title = ((NbsHeader)this.getHeader()).getTitle().isEmpty() ? (this.fileName == null ? "NBS Song" : this.fileName) : ((NbsHeader)this.getHeader()).getTitle();
        TreeMap notes = new TreeMap();
        for (NbsLayer layer : ((NbsData)this.getData()).getLayers()) {
            for (Map.Entry<Integer, NbsNote> note : layer.getNotesAtTick().entrySet()) {
                notes.computeIfAbsent(note.getKey(), k -> new ArrayList()).add(note.getValue());
            }
        }
        return new SongView<NbsNote>(title, (float)((NbsHeader)this.getHeader()).getSpeed() / 100.0f, notes);
    }
}

