/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.player;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.util.TimerHack;

public abstract class SongPlayer {
    private Song song;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> tickTask;
    private float ticksPerSecond;
    private int tick;
    private boolean paused;

    public SongPlayer(Song song) {
        this.song = song;
    }

    public void start() {
        this.start(0);
    }

    public void start(int delay) {
        if (this.isRunning()) {
            this.stop();
        }
        this.ticksPerSecond = this.song.getTempoEvents().get(0);
        this.tick = 0;
        TimerHack.ensureRunning();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "NoteBlockLib Song Player - " + this.song.getTitleOrFileNameOr("No Title"));
            thread.setPriority(6);
            thread.setDaemon(true);
            return thread;
        });
        this.createTickTask(TimeUnit.MILLISECONDS.toNanos(delay));
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.scheduler = null;
        this.tickTask = null;
        this.paused = false;
    }

    public boolean isRunning() {
        return this.scheduler != null && !this.scheduler.isTerminated();
    }

    public Song getSong() {
        return this.song;
    }

    protected void setSong(Song song) {
        this.song = song;
    }

    public float getCurrentTicksPerSecond() {
        return this.ticksPerSecond;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public int getMillisecondPosition() {
        return this.song.tickToMilliseconds(this.tick);
    }

    public void setMillisecondPosition(int milliseconds) {
        this.tick = this.song.millisecondsToTick(milliseconds);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected void createTickTask(long initialDelay) {
        if (this.tickTask != null) {
            this.tickTask.cancel(false);
        }
        this.tickTask = this.scheduler.scheduleAtFixedRate(this::tick, initialDelay, (long)(1.0E9 / (double)this.ticksPerSecond), TimeUnit.NANOSECONDS);
    }

    protected void tick() {
        try {
            if (!this.preTick()) {
                return;
            }
            try {
                if (this.paused) {
                    return;
                }
                this.playNotes(this.song.getNotes().getOrEmpty(this.tick));
                ++this.tick;
                if (this.tick >= this.song.getNotes().getLengthInTicks()) {
                    this.stop();
                    this.onFinished();
                    return;
                }
                if (this.ticksPerSecond != this.song.getTempoEvents().getEffectiveTempo(this.tick)) {
                    this.ticksPerSecond = this.song.getTempoEvents().getEffectiveTempo(this.tick);
                    this.createTickTask((long)(1.0E9 / (double)this.ticksPerSecond));
                }
            }
            finally {
                this.postTick();
            }
        }
        catch (Throwable e) {
            if (e.getCause() instanceof InterruptedException) {
                return;
            }
            e.printStackTrace();
            this.stop();
        }
    }

    protected boolean preTick() {
        return true;
    }

    protected abstract void playNotes(List<Note> var1);

    protected void onFinished() {
    }

    protected void postTick() {
    }
}

