/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import java.util.HashMap;
import java.util.Map;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;

public class NbsLayer {
    private final Map<Integer, NbsNote> notes = new HashMap<Integer, NbsNote>();
    private String name;
    private byte volume = (byte)100;
    private short panning = (short)100;
    private Status status = Status.NONE;

    public Map<Integer, NbsNote> getNotes() {
        return this.notes;
    }

    public String getName() {
        return this.name;
    }

    public String getNameOr(String fallback) {
        return this.name == null ? fallback : this.name;
    }

    public NbsLayer setName(String name) {
        this.name = name != null && !name.isEmpty() ? name : null;
        return this;
    }

    public byte getVolume() {
        return this.volume;
    }

    public NbsLayer setVolume(byte volume) {
        this.volume = volume;
        return this;
    }

    public short getPanning() {
        return this.panning;
    }

    public NbsLayer setPanning(short panning) {
        this.panning = panning;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public NbsLayer setStatus(Status status) {
        this.status = status;
        return this;
    }

    public NbsLayer copy() {
        NbsLayer copyLayer = new NbsLayer();
        copyLayer.setName(this.name);
        copyLayer.setVolume(this.volume);
        copyLayer.setPanning(this.panning);
        copyLayer.setStatus(this.status);
        Map<Integer, NbsNote> notes = this.getNotes();
        Map<Integer, NbsNote> copyNotes = copyLayer.getNotes();
        for (Map.Entry<Integer, NbsNote> entry : notes.entrySet()) {
            copyNotes.put(entry.getKey(), entry.getValue().copy());
        }
        return copyLayer;
    }

    public static enum Status {
        NONE,
        LOCKED,
        SOLO;

    }
}

