/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.Extra;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.holder.HasExtras;
import org.androidannotations.holder.HasIntentBuilder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class ExtraHandler
extends BaseAnnotationHandler<HasExtras> {
    private final AnnotationHelper annotationHelper;
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public ExtraHandler(ProcessingEnvironment processingEnvironment) {
        super(Extra.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivity(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, HasExtras holder) {
        Extra annotation = element.getAnnotation(Extra.class);
        String extraKey = annotation.value();
        String fieldName = element.getSimpleName().toString();
        if (extraKey.isEmpty()) {
            extraKey = fieldName;
        }
        JFieldVar extraKeyStaticField = this.createStaticExtraField(holder, extraKey, fieldName);
        this.injectExtraInComponent(element, holder, extraKeyStaticField, fieldName);
        if (holder instanceof HasIntentBuilder) {
            this.createIntentInjectionMethod(element, (HasIntentBuilder)((Object)holder), extraKeyStaticField, fieldName);
        }
    }

    private JFieldVar createStaticExtraField(HasExtras holder, String extraKey, String fieldName) {
        String staticFieldName = CaseHelper.camelCaseToUpperSnakeCase(null, fieldName, "Extra");
        JFieldVar staticExtraField = holder.getGeneratedClass().fields().get(staticFieldName);
        if (staticExtraField == null) {
            staticExtraField = holder.getGeneratedClass().field(25, this.classes().STRING, staticFieldName, JExpr.lit(extraKey));
        }
        return staticExtraField;
    }

    private void injectExtraInComponent(Element element, HasExtras hasExtras, JFieldVar extraKeyStaticField, String fieldName) {
        JVar extras = hasExtras.getInjectExtras();
        JBlock injectExtrasBlock = hasExtras.getInjectExtrasBlock();
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, element);
        JFieldRef extraField = JExpr.ref(fieldName);
        JBlock ifContainsKey = injectExtrasBlock._if(JExpr.invoke((JExpression)extras, "containsKey").arg(extraKeyStaticField))._then();
        JExpression restoreMethodCall = JExpr.invoke((JExpression)extras, bundleHelper.getMethodNameToRestore()).arg(extraKeyStaticField);
        if (bundleHelper.restoreCallNeedCastStatement()) {
            JMethod injectExtrasMethod;
            JClass jclass = this.codeModelHelper.typeMirrorToJClass(element.asType(), hasExtras);
            restoreMethodCall = JExpr.cast(jclass, restoreMethodCall);
            if (bundleHelper.restoreCallNeedsSuppressWarning() && (injectExtrasMethod = hasExtras.getInjectExtrasMethod()).annotations().size() == 0) {
                injectExtrasMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
            }
        }
        restoreMethodCall = this.handleByteArrayExtraBug(element, extraKeyStaticField, restoreMethodCall);
        ifContainsKey.assign(extraField, restoreMethodCall);
    }

    private JExpression handleByteArrayExtraBug(Element element, JFieldVar extraKeyStaticField, JExpression restoreMethodCall) {
        if ("byte[]".equals(element.asType().toString())) {
            restoreMethodCall = JExpr.invoke("getIntent").invoke("getByteArrayExtra").arg(extraKeyStaticField);
        }
        return restoreMethodCall;
    }

    private void createIntentInjectionMethod(Element element, HasIntentBuilder holder, JFieldVar extraKeyStaticField, String fieldName) {
        holder.getIntentBuilder().getPutExtraMethod(element.asType(), fieldName, extraKeyStaticField);
    }
}

